<div class="svq-interest-tags">
	<div class="tags-category">
		<?php foreach ( $categories as $category ): ?>
			<?php
			$image = esc_url( get_theme_file_uri( 'assets/img/cat-placeholder.png' ) );

			if ( class_exists( '\Fup\CategoryImage' ) ) {
				$image = ( new \Fup\CategoryImage() )->image_url( $category->term_id, null, false );
			}

			$image_placeholder = $image;
			$image_lazy_class  = '';

			if ( 'no-lazyload' !== get_theme_mod( 'lazy_load_media' ) ) {
				$image_placeholder = get_theme_file_uri( '/assets/img/placeholder.png' );
				$image_lazy_class  = 'lazy';
			}

			?>
			<span class="category-link has-thumbnail">
				        <a href="<?php echo get_category_link( $category ); ?>" rel="category tag" class="link-tag">
				            <span class="screen-reader-link"><?php echo esc_html( $category->cat_name ) ?></span>

					        <img class="svq-category-image <?php echo esc_attr( $image_lazy_class ); ?>"
					             src="<?php echo esc_url( $image_placeholder ) ?>"
					             data-src="<?php echo esc_url( $image ) ?>"
					             alt="<?php echo esc_attr( $category->cat_name ) ?>">
				        </a>
				    </span>
		<?php endforeach; ?>
	</div>
</div>
