<?php

namespace Seventhqueen\Typer;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class Onboarding extends \Elementor\Widget_Base {

	public function get_style_depends() {
		return [ 'swiper' ];
	}

	public function get_script_depends() {
		return [ 'swiper' ];
	}

	public function get_name() {
		return 'typer-onboarding';
	}

	public function get_title() {
		return esc_html__( 'Onboarding (Typer)', 'typer' );
	}

	public function get_icon() {
		return 'eicon-slider-push';
	}

	public function get_categories() {
		return [ 'typer-elements' ];
	}

	public function get_keywords() {
		return [ 'onboarding', 'register', 'typer' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_onboarding',
			[
				'label' => esc_html__( 'Onboarding', 'typer' )
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image',
			[
				'label'      => esc_html__( 'Add Image', 'typer' ),
				'type'       => \Elementor\Controls_Manager::MEDIA,
				'default'    => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'show_label' => false,
				'dynamic'    => [
					'active' => true,
				],
			]
		);

		$repeater->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'typer' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => '',
				'placeholder' => 'Slider title',
				'label_block' => true
			]
		);

		$repeater->add_control(
			'sub_title',
			[
				'label'       => esc_html__( 'Sub title', 'typer' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => '',
				'placeholder' => 'Slider sub title',
				'label_block' => true
			]
		);

		$repeater->add_control(
			'separator',
			[
				'label'        => esc_html__( 'Separator', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', 'typer' ),
				'label_off'    => esc_html__( 'Hide', 'typer' ),
				'return_value' => '1',
				'default'      => '0'
			]
		);

		$display_items = [
			'none'         => esc_html__( 'None', 'typer' ),
			'register-box' => esc_html__( 'Register Box', 'typer' )
		];

		$display_items = apply_filters( 'typer_onboarding_display_items', $display_items );

		$repeater->add_control(
			'link_to',
			[
				'label'       => esc_html__( 'Addons', 'typer' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => 'none',
				'options'     => $display_items,
				'label_block' => true
			]
		);

		$repeater->add_control(
			'main_button',
			[
				'label'        => esc_html__( 'Main button', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'On', 'typer' ),
				'label_off'    => esc_html__( 'Off', 'typer' ),
				'return_value' => '1',
				'default'      => '1'
			]
		);

		$repeater->add_control(
			'main_button_text',
			[
				'label'       => esc_html__( 'Main button text', 'typer' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => 'Next',
				'label_block' => true,
				'condition'   => [
					'main_button' => '1',
				]
			]
		);

		$repeater->add_control(
			'main_button_action',
			[
				'label'       => esc_html__( 'Main button action', 'typer' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => 'next',
				'options'     => [
					'next'  => esc_html__( 'Next slide', 'typer' ),
					'close' => esc_html__( 'Close popup', 'typer' )
				],
				'label_block' => true,
				'condition'   => [
					'main_button' => '1',
				]
			]
		);

		$repeater->add_control(
			'skip_button',
			[
				'label'        => esc_html__( 'Skip button', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'On', 'typer' ),
				'label_off'    => esc_html__( 'Off', 'typer' ),
				'return_value' => '1',
				'default'      => '0'
			]
		);

		$this->add_control(
			'slides',
			[
				'label'       => esc_html__( 'Slides', 'typer' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
				'default'     => [
					[
						'title' => ''
					],

				]
			]
		);

		$this->end_controls_section();

		// Style controls

		$this->start_controls_section(
			'image_style_section',
			[
				'label' => esc_html__( 'Image', 'typer' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'height',
			[
				'label'           => esc_html__( 'Width', 'typer' ),
				'type'            => \Elementor\Controls_Manager::SLIDER,
				'size_units'      => [ '%', 'px' ],
				'range'           => [
					'%'  => [
						'min'  => 0,
						'max'  => 100,
						'step' => 5,
					],
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 5,
					]
				],
				'devices'         => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 50,
					'unit' => '%',
				],
				'tablet_default'  => [
					'size' => 50,
					'unit' => '%',
				],
				'mobile_default'  => [
					'size' => 50,
					'unit' => '%',
				],
				'selectors'       => [
					'{{WRAPPER}} .onboard-image img' => 'width: {{SIZE}}{{UNIT}};'
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_style_section',
			[
				'label' => esc_html__( 'Title', 'typer' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Typography', 'typer' ),
				'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .onboard-heading',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .onboard-heading' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'title_padding',
			[
				'label'      => __( 'Padding', 'typer' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .onboard-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'subtitle_style_section',
			[
				'label' => __( 'Subtitle', 'typer' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'label'    => esc_html__( 'Typography', 'typer' ),
				'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .onboard-subheading',
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'     => esc_html__( 'Color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .onboard-subheading' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'subtitle_padding',
			[
				'label'      => esc_html__( 'Padding', 'typer' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .onboard-subheading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'separator_style_section',
			[
				'label' => esc_html__( 'Separator', 'typer' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'separator-color',
			[
				'label'     => esc_html__( 'Color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .svq-block-separator:before' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'categories_style_section',
			[
				'label' => __( 'Category Box', 'typer' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'normal-text-color',
			[
				'label'     => esc_html__( 'Box default text color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .svq-interest-tags .category-link .link-tag .screen-reader-link' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'active-text-color',
			[
				'label'     => esc_html__( 'Box active text color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .svq-interest-tags .category-link .link-tag.is-changed .screen-reader-link' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'normal-color',
			[
				'label'     => esc_html__( 'Box default color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_2,
				],
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .svq-interest-tags .category-link .link-tag:not(.is-changed):after' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'active-color',
			[
				'label'     => esc_html__( 'Box active color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .svq-interest-tags .category-link .link-tag.is-changed:before' => 'background: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'buttons_style_section',
			[
				'label' => __( 'Buttons', 'typer' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'next-btn-bg-color',
			[
				'label'     => esc_html__( 'Next Button Background', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_2,
				],
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .btn-next' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'next-btn-color',
			[
				'label'     => esc_html__( 'Next Button Color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_2,
				],
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .btn-next' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'skip-btn-color',
			[
				'label'     => esc_html__( 'Skip Button Color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_2,
				],
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .btn-onboard-skip' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'load-btn-bg-color',
			[
				'label'     => esc_html__( 'Load More Button Background', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_2,
				],
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .svq-more' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'load-btn-color',
			[
				'label'     => esc_html__( 'Load More Button Color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_2,
				],
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .svq-more' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'register-btn-bg-color',
			[
				'label'     => esc_html__( 'Register Button Background', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_2,
				],
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .svq-register-form button' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'register-btn-color',
			[
				'label'     => esc_html__( 'Register Button Color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_2,
				],
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .svq-register-form button' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$items = $this->get_settings_for_display( 'slides' );

		typer()->get_template_part( 'inc/Elementor/Widgets/templates/onboarding/onboarding', '', [
			'items' => $items
		] );
	}

}
