<?php
/**
 * Seventhqueen\Typer\Elementor\AjaxPosts class
 *
 * @package typer
 */

namespace Seventhqueen\Typer\Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use function Seventhqueen\Typer\typer;

class AjaxPosts {

	protected static $_instance;

	/**
	 * @return AjaxPosts
	 */
	public static function instance() {
		if ( self::$_instance === null ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * AjaxPosts constructor.
	 */
	public function __construct() {
		add_action( 'wp_ajax_typer_widget_get_posts', [ $this, 'ajax_build_template' ] );
		add_action( 'wp_ajax_no_priv_typer_widget_get_posts', [ $this, 'ajax_build_template' ] );
	}

	/**
	 * Build template
	 *
	 * @param array $params
	 */
	public function build_template( $params = [] ) {
		$args = [
			'post_type'           => 'post',
			'post_status'         => [ 'publish' ],
			'ignore_sticky_posts' => $params['ignore_sticky_posts'],
			'post__not_in'        => $params['post__not_in'],
		];

		if ( isset( $params['posts_per_page'] ) ) {
			$args['posts_per_page'] = $params['posts_per_page'];
		}

		if ( isset( $params['showposts'], $params['offset'] ) ) {
			$args['showposts'] = $params['showposts'];
			$args['offset']    = $params['offset'];
		} elseif ( isset( $params['offset'] ) && $params['typer_settings']['pagination'] ) {
			$args['offset'] = $params['offset'];
		}

		if ( isset( $params['category__in'] ) ) {
			$args['category__in'] = $params['category__in'];
		}

		if ( isset( $params['tag__in'] ) ) {
			$args['tag__in'] = $params['tag__in'];
		}

		if ( isset( $params['orderby'] ) ) {
			$args['orderby'] = $params['orderby'];
		}

		if ( isset( $params['order'] ) ) {
			$args['order'] = $params['order'];
		}

		$query = new \WP_Query( $args );

		if ( $params['typer_settings']['image_wide'] ) {
			$params['typer_settings']['media_width']        = 'wide';
			$params['typer_settings']['media_aspect_ratio'] = '16-9';
			$params['typer_settings']['media_size']         = 'typer-img-lg';
		} else {
			$params['typer_settings']['media_width']        = 'normal';
			$params['typer_settings']['media_aspect_ratio'] = '1-1';
			$params['typer_settings']['media_size']         = 'typer-img-md';
		}

		if ( $params['typer_settings']['title'] ) {
			?>
			<h3 class="widget-title"><span><?php echo esc_html( $params['typer_settings']['title'] ) ?></span></h3>
			<?php
		}

		typer()->get_template_part( 'inc/Elementor/Widgets/templates/posts/' . $params['typer_settings']['listing'], '', [
			'query'  => $query,
			'params' => $params
		] );

		wp_reset_postdata();
	}

	/**
	 * Handle ajax request
	 */
	public function ajax_build_template() {
		check_ajax_referer( 'typer-widget-get-posts', 'check' );

		$default_params = [
			'typer_settings'      => [
				'title'                   => '',
				'image_wide'              => '',
				'listing'                 => '',
				'show_category'           => '',
				'show_meta'               => '',
				'show_excerpt'            => '',
				'image_position'          => '',
				'big_post'                => '',
				'pagination'              => '',
				'pagination_next_prev'    => '',
				'pagination_page_numbers' => '',
				'pagination_ajax'         => '',
				'col-grid-mobile'         => '',
				'col-grid-tablet'         => '',
				'col-grid-desktop'        => '',
				'col-mobile'              => '',
				'col-tablet'              => '',
				'col-desktop'             => '',
				'current_page'            => ''
			],
			'ignore_sticky_posts' => '',
			'post__not_in'        => '',
			'posts_per_page'      => '',
			'offset'              => '',
			'category__in'        => '',
			'tag__in'             => '',
		];

		if ( ! isset( $_POST['params'] ) || ! is_array( $_POST['params'] ) ) {
			echo '';
			die();
		}

		$request_params = $_POST['params'];
		$params         = array_merge( $default_params, $request_params );

		$params['typer_settings']['current_page'] = (int) $_POST['page'];

		$params['offset'] = ( $params['typer_settings']['current_page'] - 1 ) * (int) $params['posts_per_page'];

		ob_start();
		$this->build_template( $params );
		echo ob_get_clean();
		die();
	}

}
