<?php
/**
 * This class handles extending Kirki plugin framework.
 *
 * @package Typer\Customizer
 *
 * @since 1.0.0
 */

namespace Seventhqueen\Typer\Customizer\Modules\Kirki_Extend;

// Exit if accessed directly.
use Seventhqueen\Typer\Customizer\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Define all customizer utils.
 *
 * @since 1.0.0
 * @ignore
 * @access private
 *
 * @package Typer\Customizer
 */
final class Module {

	/**
	 * Control outputs.
	 *
	 * @since 1.0.0
	 *
	 * @var array
	 */
	public $control_outputs = [
		'sq-control-background' => '\Seventhqueen\Typer\Customizer\Modules\Kirki_Extend\Output\Background',
		'sq-control-box-model'  => '\Seventhqueen\Typer\Customizer\Modules\Kirki_Extend\Output\Box_Model',
		'sq-control-box-shadow' => '\Seventhqueen\Typer\Customizer\Modules\Kirki_Extend\Output\Box_Shadow',
		'sq-control-border'     => '\Seventhqueen\Typer\Customizer\Modules\Kirki_Extend\Output\Border',
		'sq-control-input'      => '\Seventhqueen\Typer\Customizer\Modules\Kirki_Extend\Output\Input',
	];

	/**
	 * Module activate condition.
	 *
	 * @since 1.0.0
	 *
	 * @return boolean Class active state.
	 */
	public static function active() {
		return class_exists( '\Kirki' );
	}

	/**
	 * Construct the class.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {

		add_filter( 'kirki_section_types', [ $this, 'add_section_types' ] );
		add_filter( 'kirki_control_types', [ $this, 'add_control_types' ] );
		add_filter( 'kirki_typer_options_output_control_classnames', [ $this, 'add_control_outputs' ] );
	}

	/**
	 * Add custom section types to Kirki.
	 *
	 * @since 1.0.0
	 *
	 * @param array $section_types Defined section types from Kirki.
	 *
	 * @return array
	 */
	public function add_section_types( $section_types = [] ) {
		return array_merge( $section_types, Helper::$section_types );
	}

	/**
	 * Add custom control types to Kirki.
	 *
	 * @since 1.0.0
	 *
	 * @param array $control_types Defined control types from Kirki.
	 *
	 * @return array
	 */
	public function add_control_types( $control_types = [] ) {
		return array_merge( $control_types, Helper::$control_types, Helper::$group_control_types );
	}

	/**
	 * Add custom control outputs to Kirki.
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
	public function add_control_outputs( $outputs ) {

		$outputs = $outputs + $this->control_outputs;

		$controls = array_merge( Helper::$control_types, Helper::$group_control_types );

		foreach ( $controls as $control => $class ) {
			if ( ! key_exists( $control, $outputs ) ) {
				$outputs[ $control ] = '\Seventhqueen\Typer\Customizer\Modules\Kirki_Extend\Base\Output';
			}
		}

		return $outputs;
	}
}
