<?php
/**
 * This file adds a custom section in the customizer that recommends the installation of the Kirki plugin.
 */

namespace Seventhqueen\Typer\Customizer;


class Kirki_Installer_Section extends \WP_Customize_Section {

	/**
	 * Customize section type.
	 *
	 * @access public
	 * @var string
	 */
	public $type = 'kirki_installer';

	/**
	 * The plugin install URL.
	 *
	 * @access private
	 * @var string
	 */
	public $plugin_install_url;

	/**
	 * Render the section.
	 *
	 * @access protected
	 */
	protected function render() {

		// Don't proceed any further if the user has dismissed this.
		if ( $this->is_dismissed() ) {
			return;
		}

		// Determine if the plugin is not installed, or just inactive.
		$plugins   = get_plugins();
		$installed = false;
		foreach ( $plugins as $plugin ) {
			if ( 'Typer Core' === $plugin['Name'] ) {
				$installed = true;
			}
		}
		$plugin_install_url = $this->get_plugin_install_url();
		$classes            = 'cannot-expand accordion-section control-section control-section-themes control-section-' . $this->type;
		?>
		<li id="accordion-section-<?php echo esc_attr( $this->id ); ?>" class="<?php echo esc_attr( $classes ); ?>"
		    style="border-top:none;border-bottom:1px solid #ddd;padding:7px 14px 16px 14px;text-align:right;">
			<?php if ( ! $installed ) : ?>
				<?php $this->install_button(); ?>
			<?php else : ?>
				<?php $this->activate_button(); ?>
			<?php endif; ?>
			<?php $this->dismiss_button(); ?>
		</li>
		<?php
	}

	/**
	 * Check if the user has chosen to hide this.
	 *
	 * @static
	 * @access public
	 * @return bool
	 * @since 1.0.0
	 */
	public static function is_dismissed() {
		// Get the user-meta.
		$user_id = get_current_user_id();
		// @codingStandardsIgnoreLine WordPress.VIP.RestrictedFunctions.user_meta_get_user_meta)
		$user_meta = get_user_meta( $user_id, 'dismiss-kirki-recommendation', true );

		return ( true === $user_meta || '1' === $user_meta || 1 === $user_meta );
	}

	/**
	 * Adds the install button.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	protected function install_button() {
		?>
		<p style="text-align:left;margin-top:0;">
			<?php esc_attr_e( 'Please install the Typer Core plugin to take full advantage of this theme\'s customizer capabilities', 'typer' ); ?>
		</p>
		<a class="install-now button-primary button" data-slug="kirki"
		   href="<?php echo esc_url_raw( $this->get_plugin_install_url() ); ?>"
		   aria-label="<?php esc_attr_e( 'Install Typer Core now', 'typer' ); ?>" data-name="Typer Core">
			<?php esc_html_e( 'Install Now', 'typer' ); ?>
		</a>
		<?php
	}

	/**
	 * Adds the install button.s
	 *
	 * @return void
	 * @since 1.0.0
	 */
	protected function activate_button() {

		$plugin_file = 'typer-core/loader.php';
		$context     = 'all';
		$page        = '1';
		$s           = '';
		$current_url = admin_url( 'customize.php' );
		$url         = wp_nonce_url( $current_url . '?svq_action=activate_plugin&plugin=typer-core&redirect=' . $current_url, 'activate_plugin', 'svq_nonce' );
		//$url = wp_nonce_url( 'plugins.php?action=activate&amp;plugin=' . urlencode( $plugin_file ) . '&amp;plugin_status=' . $context . '&amp;paged=' . $page . '&amp;s=' . $s, 'activate-plugin_' . $plugin_file )

		?>
		<p style="text-align:left;margin-top:0;">
			<?php esc_attr_e( 'You have installed Typer Core. Activate it to start customizing our theme.', 'typer' ); ?>
		</p>
		<a class="activate-now button-primary button" data-slug="typer-core"
		   href="<?php echo esc_url_raw( $url ); ?>"
		   aria-label="<?php esc_attr_e( 'Activate Typer Core now', 'typer' ); ?>" data-name="Typer Core">
			<?php esc_html_e( 'Activate Now', 'typer' ); ?>
		</a>
		<?php
	}

	/**
	 * Adds the dismiss button and script.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	protected function dismiss_button() {

		// Create the nonce.
		$ajax_nonce = wp_create_nonce( 'dismiss-kirki-recommendation' );

		// Show confirmation dialog on dismiss?
		$show_confirm = true;
		?>
		<a class="kirki-installer-dismiss button-secondary button" data-slug="kirki" href="#"
		   aria-label="<?php esc_attr_e( 'Don\'t show this again', 'typer' ); ?>"
		   data-name="<?php esc_attr_e( 'Dismiss', 'typer' ); ?>">
			<?php esc_attr_e( 'Don\'t show this again', 'typer' ); ?>
		</a>

		<script type="text/javascript">
			jQuery(document).ready(function() {
				jQuery('.kirki-installer-dismiss').on('click', function(event) {

					event.preventDefault();

					<?php if ( $show_confirm ) : ?>
					if (!confirm(
						'<?php esc_attr_e( 'Are you sure? Dismissing this message will hide the installation recommendation and you will have to manually install and activate the plugin in the future.', 'typer' ); ?>')) {
						return;
					}
					<?php endif; ?>

					jQuery.post(ajaxurl, {
						action: 'kirki_installer_dismiss',
						security: '<?php echo esc_attr( $ajax_nonce ); ?>',
					}, function(response) {
						jQuery('#accordion-section-kirki_installer').remove();
					});
				});
			});
		</script>
		<?php
	}

	/**
	 * Get the plugin install URL.
	 *
	 * @access private
	 * @return string
	 */
	private function get_plugin_install_url() {
		if ( ! $this->plugin_install_url ) {
			// Get the plugin-installation URL.
			$this->plugin_install_url = add_query_arg(
				[
					'action' => 'install-plugin',
					'plugin' => 'typer-core',
				],
				self_admin_url( 'update.php' )
			);

			$current_url              = admin_url( 'customize.php' );
			$this->plugin_install_url = wp_nonce_url( $current_url . '?svq_action=activate_plugin&plugin=typer-core&redirect=' . $current_url, 'activate_plugin', 'svq_nonce' );
		}

		return $this->plugin_install_url;
	}
}
