<?php
/**
 * Handles toggle control class.
 *
 * @package Typer\Customizer
 *
 * @since 1.0.0
 */

namespace Seventhqueen\Typer\Customizer\Control;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Toggle control class.
 *
 * @since 1.0.0
 * @ignore
 * @access private
 *
 * @package Typer\Customizer
 */
class Toggle extends \Seventhqueen\Typer\Customizer\Base\Input_Group {

	/**
	 * Control's type.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $type = 'sq-control-toggle';

	/**
	 * An Underscore (JS) template for control field.
	 *
	 * @since 1.0.0
	 */
	protected function group_field_template() {
		?>
		<label class="typer-toggle-control-label">
			<input class="typer-toggle-control-checkbox screen-reader-text" {{{ data.inputAttrs }}} type="checkbox" id="{{ data.id }}" value="{{ data.value }}" <# if ( data.value ) { #> checked <# } #> hidden {{{ data.link }}} />
			<span class="typer-toggle-control-switch"></span>
		</label>
		<?php
	}
}
