<?php
/**
 * Handles textarea control class.
 *
 * @package Typer\Customizer
 *
 * @since 1.0.0
 */

namespace Seventhqueen\Typer\Customizer\Control;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Textarea control class.
 *
 * @since 1.0.0
 * @ignore
 * @access private
 *
 * @package Typer\Customizer
 */
class Textarea extends \Seventhqueen\Typer\Customizer\Base\Input_Group {

	/**
	 * Control's type.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $type = 'sq-control-textarea';

	/**
	 * An Underscore (JS) template for control field.
	 *
	 * @since 1.0.0
	 */
	protected function group_field_template() {
		?>
		<textarea class="typer-textarea-control-field" {{{ data.inputAttrs }}} id="{{ data.id }}" {{{ data.link }}}>{{ data.value }}</textarea>
		<?php
	}
}
