<?php
/**
 * Handles radio image control class.
 *
 * @package Typer\Customizer
 *
 * @since 1.0.0
 */

namespace Seventhqueen\Typer\Customizer\Control;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Radio image control class.
 *
 * @since 1.0.0
 * @ignore
 * @access private
 *
 * @package Typer\Customizer
 */
class Radio_Image extends \Seventhqueen\Typer\Customizer\Base\Control {

	/**
	 * Control's type.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $type = 'sq-control-radio-image';

	/**
	 * An Underscore (JS) template for control wrapper.
	 *
	 * Use to create the control template.
	 *
	 * @since 1.0.0
	 */
	protected function control_template() {
		?>
		<div class="typer-control typer-radio-image-control">
			<div class="typer-radio-image-control-buttons">
				<# _.each( data.choices, function( image, key ) { #>
					<input class="typer-radio-image-control-radio" {{{ data.inputAttrs }}} type="radio" value="{{ key }}" name="{{ data.id }}" id="{{ data.id }}-{{ key }}" {{{ data.link }}} <# if ( key === data.value ) { #> checked <# } #>>
					<label class="typer-radio-image-control-button" for="{{ data.id }}-{{ key }}">
						<span class="option-wrapper">
							<img alt="{{ image.alt }}" title="{{ image.alt }}" src="{{ image.img }}" />
							<span class="option-description">{{ image.alt }}</span>
						</span>
					</label>
				<# } ) #>
			</div>
		</div>
		<?php
	}
}
