<?php
/**
 * Handles multicheck control class.
 *
 * @package Typer\Customizer
 *
 * @since 1.0.0
 */

namespace Seventhqueen\Typer\Customizer\Control;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Multicheck control class.
 *
 * @since 1.0.0
 * @ignore
 * @access private
 *
 * @package Typer\Customizer
 */
class Multicheck extends \Seventhqueen\Typer\Customizer\Base\Control {

	/**
	 * Control's type.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $type = 'sq-control-multicheck';

	/**
	 * Choices via icons.
	 *
	 * @since 1.0.0
	 *
	 * @var array
	 */
	public $icon_choices = [];

	/**
	 * Refresh the parameters passed to the JavaScript via JSON.
	 *
	 * @since 1.0.0
	 */
	public function to_json() {
		parent::to_json();

		$this->json['iconChoices'] = $this->icon_choices;
	}

	/**
	 * An Underscore (JS) template for control wrapper.
	 *
	 * Use to create the control template.
	 *
	 * @since 1.0.0
	 */
	protected function control_template() {
		?>
		<div class="typer-control typer-multicheck-control">
			<# if ( ! _.isEmpty( data.iconChoices ) ) { #>
				<div class="typer-multicheck-control-icon-items">
					<# _.each( data.iconChoices, function( icon, key ) { #>
						<div class="typer-multicheck-control-icon-item">
							<input class="typer-multicheck-control-checkbox" {{{ data.inputAttrs }}} type="checkbox" value="{{ key }}" id="{{ data.id }}-{{ key }}" <# if ( data.value.indexOf( key ) >= 0 ) { #> checked <# } #>>
							<label class="typer-multicheck-control-icon-label" for="{{ data.id }}-{{ key }}"><img src="<?php echo esc_url( \Seventhqueen\Typer\Customizer\Utils::get_assets_url() ); ?>/img/{{ icon }}.svg" /></label>
						</div>
					<# } ) #>
				</div>
			<# } #>
			<# if ( ! _.isEmpty( data.choices ) ) { #>
				<div class="typer-multicheck-control-items">
					<# _.each( data.choices, function( label, key ) { #>
						<div class="typer-multicheck-control-item">
							<input class="typer-multicheck-control-checkbox" {{{ data.inputAttrs }}} type="checkbox" value="{{ key }}" id="{{ data.id }}-{{ key }}" <# if ( data.value.indexOf( key ) >= 0 ) { #> checked <# } #>>
							<label class="typer-multicheck-control-label" for="{{ data.id }}-{{ key }}"><span class="typer-multicheck-control-box"></span> {{ label }}</label>
						</div>
					<# } ) #>
				</div>
			<# } #>
			<input type="hidden" value="{{ data.value }}" {{{ data.link }}}>
		</div>
		<?php
	}

	/**
	 * Format CSS value from theme mod array value.
	 *
	 * @since 1.0.0
	 *
	 * @param array $value The field's value.
	 *
	 * @return array The formatted properties.
	 */
	public static function format_properties( $value ) {
		$vars = [];

		foreach ( $value as $key ) {
			$vars[ $key ] = 'true';
		}

		return $vars;
	}
}
