<?php
/**
 * Handles input slider control class.
 *
 * @package Typer\Customizer
 *
 * @since 1.0.0
 */

namespace Seventhqueen\Typer\Customizer\Control;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Input_Slider control class.
 *
 * @since 1.0.0
 * @ignore
 * @access private
 *
 * @package Typer\Customizer
 */
class Input_Slider extends \Seventhqueen\Typer\Customizer\Base\Control {

	/**
	 * Control's type.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $type = 'sq-control-input-slider';

	/**
	 * Choices.
	 *
	 * @since 1.0.0
	 *
	 * @var array
	 */
	public $choices = [];

	/**
	 * Refresh the parameters passed to the JavaScript via JSON.
	 *
	 * @since 1.0.0
	 */
	public function to_json() {
		parent::to_json();
	}

	/**
	 * An Underscore (JS) template for control wrapper.
	 *
	 * Use to create the control template.
	 *
	 * @since 1.0.0
	 */
	protected function control_template() {
		?>
		<div class="input-rangeslider-wrap">
			<input class="input-rangeslider" type="range" min="{{ data.choices.min }}" max="{{ data.choices.max }}"
			       value="{{ data.value }}" step="{{ data.choices.step }}"
			       {{{ data.inputAttrs }}} id="{{ data.id }}" {{{ data.link }}}>
		</div>
		<?php
	}
}
