<?php

namespace Seventhqueen\Typer\Config\Customizer;

use function Seventhqueen\Typer\typer;

/**
 * Class TypographyOptions
 * @package Seventhqueen\Typer\Config\Customizer
 */
class TypographyOptions {

	/**
	 * @var array
	 */
	private $sq = [];

	/**
	 * @var string
	 */
	private $panel = '';

	/**
	 * @param $name
	 *
	 * @return $this
	 */
	public function set_panel_name( $name ) {
		$this->panel = $name;

		return $this;
	}

	/**
	 * @param int $priority
	 *
	 * @return array
	 */
	public function get_section( $priority = 10 ) {
		return [
			'title'    => esc_html__( 'Typography', 'typer' ),
			'panel'    => $this->panel,
			'priority' => $priority
		];
	}

	/**
	 * @return string
	 */
	public function get_section_slug() {
		return 'svq_section_typography';
	}

	/**
	 * @return array
	 */
	public function get_options() {


		$this->sq['google_font_use_local'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'switch',
			'default'     => '1',
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'typer' ),
				'off' => esc_html__( 'Disable', 'typer' ),
			],
			'label'   => esc_html__( 'Local Google Fonts', 'typer' ),
			'description'   => esc_html__( 'When enabled it will download and load Google fonts from your site.', 'typer' ),
		];



		$this->sq['base_typography_separator'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-separator',
			'label'   => esc_html__( 'Body', 'typer' ),
		];

		$this->sq['base_typography'] = [
			'section'   => $this->get_section_slug(),
			'type'      => 'typography',
			'label'     => esc_attr__( 'Typography', 'typer' ),
			'transport' => 'auto',
			'default'   => [
				'font-family' => 'Mukta',
				'variant'     => 'regular',
			],
			'choices'   => [
				'fonts'   => [
					'google' => [ 'popularity', 300 ],
				],
				'variant' => [ 'italic', '700' ],
			],
			'output'    => is_customize_preview() || is_admin() ? [
				[
					'element' => 'body',
				],
			] : false,
			'css_vars'  => [
				[ '--font-family', '$', 'font-family' ],
			],
		];

		$this->sq['font_size'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'sq-control-input',
			'title'       => esc_html__( 'Font size', 'typer' ),
			'default'     => [
				'desktop' => [
					'size' => '1.19',
					'unit' => 'rem',
				],
				'tablet'  => [
					'size' => '1.13',
					'unit' => 'rem',
				],
				'mobile'  => [
					'size' => '1',
					'unit' => 'rem',
				],
			],
			'column'      => '4',
			'units'       => [ 'px', 'em', 'rem' ],
			'defaultUnit' => 'rem',
			'responsive'  => true,
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--font-size-sm', '$', 'mobile' ],
				[ '--font-size-md', '$', 'tablet' ],
				[ '--font-size-lg', '$', 'desktop' ],
			],
		];

		$this->sq['line_height'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'sq-control-input',
			'title'       => esc_html__( 'L Height', 'typer' ),
			'default'     => [
				'desktop' => [
					'size' => '1.7',
					'unit' => '-',
				],
				'tablet'  => [
					'size' => '1.6',
					'unit' => '-',
				],
				'mobile'  => [
					'size' => '1.5',
					'unit' => '-',
				],
			],
			'column'      => '4',
			'units'       => [ '-', 'px', 'em', 'rem' ],
			'defaultUnit' => '-',
			'responsive'  => true,
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--line-height-sm', '$', 'mobile' ],
				[ '--line-height-md', '$', 'tablet' ],
				[ '--line-height-lg', '$', 'desktop' ],
			],
		];

		$this->sq['letter_spacing'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-input',
			'title'   => esc_html__( 'L Spacing', 'typer' ),

			'default'     => [
				'size' => '0.03',
				'unit' => 'rem',
			],
			'column'      => '4',
			'units'       => [ '-', 'px', 'em', 'rem' ],
			'defaultUnit' => 'em',
			'transport'   => 'postMessage',
			'output'      => is_customize_preview() || is_admin() ? [
				[
					'element'  => 'body',
					'property' => 'letter-spacing',
				],
			] : false,
		];

		$this->sq['base_typography_headings'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-separator',
			'label'   => esc_html__( 'Headings', 'typer' )
		];

		$this->sq['heading_typography'] = [
			'section'   => $this->get_section_slug(),
			'type'      => 'typography',
			'label'     => esc_attr__( 'Default Typography', 'typer' ),
			'transport' => 'auto',
			'default'   => [
				'font-family' => 'Heebo',
				'variant'     => '900',
			],
			'choices'   => [
				'fonts'   => [
					'google' => [ 'popularity', 300 ],
				],
				'variant' => [ 'italic' ],
			],
			'output'    => is_customize_preview() ? [
				[
					'element' => 'h1, h2, h3, h4, h5, h6'
				],
			] : false,
			'css_vars'  => [
				[ '--heading-font-family', '$', 'font-family' ],
				[ '--h1-font-weight', '$', 'variant' ],
				[ '--h2-font-weight', '$', 'variant' ],
				[ '--h3-font-weight', '$', 'variant' ],
				[ '--h4-font-weight', '$', 'variant' ],
				[ '--h5-font-weight', '$', 'variant' ],
				[ '--h6-font-weight', '$', 'variant' ]
			],
		];

		$this->sq['heading_line_height'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'sq-control-input',
			'title'       => esc_html__( 'Default Line Height', 'typer' ),
			'default'     => [
				'size' => '1.2',
				'unit' => '-'
			],
			'column'      => '12',
			'units'       => [ '-', 'px', 'em', 'rem' ],
			'defaultUnit' => '-',
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--heading-line-height' ],
			],
		];

		$default_sizes = typer()->get_config( 'font_sizes' );
		for ( $i = 1; $i <= 6; $i ++ ) {
			$this->sq[ 'h' . $i . '_font_size' ] = [
				'section'     => $this->get_section_slug(),
				'type'        => 'sq-control-input',
				'title'       => sprintf( esc_html__( 'H%s Font size', 'typer' ), $i ),
				'default'     => $default_sizes[ 'h' . $i ],
				'column'      => '6',
				'units'       => [ 'px', 'em', 'rem' ],
				'defaultUnit' => 'rem',
				'responsive'  => true,
				'transport'   => 'postMessage',
				'css_vars'    => [
					[ '--h' . $i . '-font-size-sm', '$', 'mobile' ],
					[ '--h' . $i . '-font-size-md', '$', 'tablet' ],
					[ '--h' . $i . '-font-size-lg', '$', 'desktop' ],
				],
			];

			$this->sq[ 'h' . $i . '_line_height' ] = [
				'section'     => $this->get_section_slug(),
				'type'        => 'sq-control-input',
				'title'       => esc_html__( 'Line Height', 'typer' ),
				'default'     => [
					'desktop' => [
						'size' => '',
						'unit' => '-',
					],
					'tablet'  => [
						'size' => '',
						'unit' => '-',
					],
					'mobile'  => [
						'size' => '',
						'unit' => '-',
					],
				],
				'column'      => '6',
				'units'       => [ '-', 'px', 'em', 'rem' ],
				'defaultUnit' => '-',
				'responsive'  => true,
				'transport'   => 'postMessage',
				'css_vars'    => [
					[ '--h' . $i . '-line-height-sm', '$', 'mobile' ],
					[ '--h' . $i . '-line-height-md', '$', 'tablet' ],
					[ '--h' . $i . '-line-height-lg', '$', 'desktop' ],
				],
			];
		}

		$this->sq['base_typography_quote'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-separator',
			'label'   => esc_html__( 'Quote', 'typer' )
		];

		$this->sq['quote_typography'] = [
			'section'   => $this->get_section_slug(),
			'type'      => 'typography',
			'label'     => esc_attr__( 'Typography', 'typer' ),
			'transport' => 'auto',
			'default'   => [
				'font-family' => 'Noto Serif',
				'variant'     => 'regular'
			],
			'choices'   => [
				'fonts'   => [
					'google' => [ 'popularity', 300 ],
				],
				'variant' => [ 'italic' ],
			],
			'output'    => is_customize_preview() ? [
				[
					'element' => 'blockquote'
				],
			] : false,
			'css_vars'  => [
				[ '--quote-font-family', '$', 'font-family' ],
			],
		];

		return $this->sq;
	}

}
