<?php

namespace Seventhqueen\Typer\Config\Customizer;

use function Seventhqueen\Typer\typer;

/**
 * Class MiscOptions
 * @package Seventhqueen\Typer\Config\Customizer
 */
class MiscOptions {

	/**
	 * @var array
	 */
	private $sq = [];

	/**
	 * @var string
	 */
	private $panel = '';

	/**
	 * @param $name
	 *
	 * @return $this
	 */
	public function set_panel_name( $name ) {
		$this->panel = $name;

		return $this;
	}

	/**
	 * @param int $priority
	 *
	 * @return array
	 */
	public function get_section( $priority = 10 ) {
		return [
			'title'    => esc_html__( 'Miscellaneous', 'typer' ),
			'panel'    => $this->panel,
			'priority' => $priority
		];
	}

	/**
	 * @return string
	 */
	public function get_section_slug() {
		return 'svq_section_misc';
	}

	/**
	 * @return array
	 */
	public function get_options() {

		$this->sq['page_preloader'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'switch',
			'choices'     => typer()->get_config( 'switch_options' ),
			'default'     => '0',
			'title'       => esc_html__( 'Page preloader', 'typer' ),
			'description' => esc_html__( 'Display a page preloader when navigating.', 'typer' ),
		];

		$this->sq['maintenance_mode'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'switch',
			'choices'     => typer()->get_config( 'switch_options' ),
			'default'     => '0',
			'title'       => esc_html__( 'Maintenance Enabled', 'typer' ),
			'description' => esc_html__( 'WARNING: It will make the site available to admins only', 'typer' ),
		];

		$this->sq['maintenance_msg'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'textarea',
			'default'     => 'We are not available for the moment!!!',
			'title'       => esc_html__( 'Maintenance Message', 'typer' ),
			'description' => esc_html__( 'The message that is visible for guests if you enabled maintenance', 'typer' ),
			'condition'   => [ 'maintenance_mode', 1 ]
		];

		$this->sq['page_comments_disable'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'switch',
			'choices'     => typer()->get_config( 'switch_options' ),
			'default'     => '0',
			'title'       => esc_html__( 'Disable page comments', 'typer' ),
			'description' => esc_html__( 'Force disable comments on all pages', 'typer' ),
		];

		$this->sq['post_comments_disable'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'switch',
			'choices'     => typer()->get_config( 'switch_options' ),
			'default'     => '0',
			'title'       => esc_html__( 'Disable post comments', 'typer' ),
			'description' => esc_html__( 'Force disable comments on all posts. Will override any site or post Discussion Settings', 'typer' ),
		];

		$this->sq['post_modified_date'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'switch',
			'choices'     => typer()->get_config( 'switch_options' ),
			'default'     => '0',
			'title'       => esc_html__( 'Display post updated date', 'typer' ),
			'description' => esc_html__( 'Show post updated date instead of published date on lists and single page', 'typer' ),
		];

		$this->sq['quick_js'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'textarea',
			'default'     => '',
			'title'       => esc_html__( 'Quick Javascript', 'typer' ),
			'description' => esc_html__( 'Small JS code to load in the footer of your site. You need to include the script tags.', 'typer' ),
		];

		$this->sq['dev_mode'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'switch',
			'choices'     => typer()->get_config( 'switch_options' ),
			'default'     => '0',
			'title'       => esc_html__( 'Development mode', 'typer' ),
			'description' => esc_html__( 'This will load css/js files not minified.', 'typer' ),
		];

		return $this->sq;

	}

}
