<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package typer
 */

namespace Seventhqueen\Typer;

if ( post_password_required() ) {
	return;
}

$comments_classes = [];

if ( typer()->get_option( 'blog_comments_modal' ) ) {
	$comments_classes[] = 'svq-comments--modal';
} else {
	$comments_classes[] = 'svq-comments--default';
}

$comments_classes = implode( ' ', $comments_classes );

\Typer_Assets::instance()->enqueue_comments_reply();
\Typer_Assets::instance()->enqueue_fancybox();
?>

<div id="comments-post-<?php echo esc_attr( get_the_ID() ); ?>"
     class="svq-section-comments <?php echo esc_attr( $comments_classes ) ?>"
     data-post-id="<?php echo esc_attr( get_the_ID() ); ?>">
	<div class="svq-status-comments <?php echo esc_attr( have_comments() ? 'has-comments' : '' ) ?>">

		<div class="svq-svg-icon-wrapp"
		     data-svg-notifier="<?php echo( ( have_comments() ) ? esc_attr( get_comments_number() ) : '' ) ?>">
			<span class="icon icon-comment-lines icon--x64"></span>
		</div>

		<?php if ( ! have_comments() ): ?>
			<h5 class="comments-stat-info"
				data-first="<?php esc_attr_e( 'People reacted to this story.', 'typer' ) ?>">
				<?php esc_html_e( 'No Comments', 'typer' ) ?>
			</h5>
			<?php if ( typer()->get_option( 'blog_comments_modal' ) ) : ?>
				<div class="comments-stat-action">
					<a class="btn btn-sm btn-primary btn-glow button-ripple show-responses">
						<span class="btn--default-state"><?php esc_html_e( 'Leave a comment', 'typer' ) ?></span>
					</a>
				</div>
			<?php else: ?>
				<a class="btn btn-sm btn-primary btn-glow button-ripple"
				   data-action="btn-comments-trigger" data-post-id="<?php echo esc_attr( get_the_ID() ); ?>">
					<span class="btn--default-state"><?php esc_html_e( 'Leave a comment', 'typer' ) ?></span>
					<span class="btn--active-state"><?php esc_html_e( 'Cancel', 'typer' ) ?></span>
				</a>
			<?php endif; ?>
		<?php else: ?>
			<h5 class="comments-stat-info"><?php esc_html_e( 'People reacted to this story.', 'typer' ) ?></h5>
			<?php if ( typer()->get_option( 'blog_comments_modal' ) ) : ?>
				<div class="comments-stat-action">
					<a class="btn btn-sm btn-primary btn-glow button-ripple show-responses">
						<span class="btn--default-state"><?php esc_html_e( 'Show comments', 'typer' ) ?></span>
					</a>
				</div>
			<?php else: ?>
				<a class="btn btn-sm btn-primary btn-glow button-ripple"
				   data-action="btn-comments-trigger" data-post-id="<?php echo esc_attr( get_the_ID() ); ?>">
					<span class="btn--default-state"><?php esc_html_e( 'Show comments', 'typer' ) ?></span>
					<span class="btn--active-state"><?php esc_html_e( 'Hide comments', 'typer' ) ?></span>
				</a>
			<?php endif; ?>
		<?php endif; ?>
	</div>

	<?php typer()->get_template_part( 'template-parts/content/comment-list' ) ?>

	<?php
	if ( ! typer()->get_option( 'blog_comments_modal' ) ) {
		typer()->custom_comment_form();
	}
	?>
</div>
