var Typer_CustomizerPanel = Typer_CustomizerPanel || {};

(function ($, wp) {

	// USE STRICT
	"use strict";

	Typer_CustomizerPanel.formats = [
		'general',
		'standard',
		'image',
		'quote',
		'audio',
		'video',
		'gallery'
	];

	Typer_CustomizerPanel.controls = {
		size: {
			slug: 'media_fullscreen',
			selector: 'data-customize-setting-link'
		},
		inherit: {
			slug: 'media_settings_overwrite',
			selector: 'data-customize-setting-link',
		},
		height: {
			slug: 'media_max_height',
			selector: 'data-customize-setting-link'
		},
		imageWidth: {
			slug: 'media_image_width',
			selector: 'data-id'
		},
		videoWidth: {
			slug: 'media_video_width',
			selector: 'data-id'
		},
		galleryWidth: {
			slug: 'media_gallery_width',
			selector: 'data-id'
		}
	};

	Typer_CustomizerPanel.initialize = {
		heightOptionWatcher: function () {
			let formats = Typer_CustomizerPanel.formats;
			let controls = Typer_CustomizerPanel.controls;

			for (let i in formats) {
				$('#accordion-section-svq_section_blog_' + formats[i]).on('click', function (e) {
					let size = $('[' + controls.size.selector + '="' + controls.size.slug + '_' + formats[i] + '"' + ']');

					let inherit = $('[' + controls.inherit.selector + '="' + controls.inherit.slug + '_' + formats[i] + '"' + ']');

					if (inherit.is(':checked'))
						return false;

					let height = $('[' + controls.height.selector + '="' + controls.height.slug + '_' + formats[i] + '"' + ']');
					let imageWidth = $('[' + controls.imageWidth.selector + '="' + controls.imageWidth.slug + '_' + formats[i] + '"' + ']');
					let videoWidth = $('[' + controls.videoWidth.selector + '="' + controls.videoWidth.slug + '_' + formats[i] + '"' + ']');
					let galleryWidth = $('[' + controls.galleryWidth.selector + '="' + controls.galleryWidth.slug + '_' + formats[i] + '"' + ']');

					if (size.length) {
						Typer_CustomizerPanel.initialize.triggerChange(size, height, imageWidth, videoWidth, galleryWidth);

						size.on('change', function (e) {
							Typer_CustomizerPanel.initialize.triggerChange($(this), height, imageWidth, videoWidth, galleryWidth);
							setTimeout(function () {
								let iframe = document.getElementsByTagName('iframe');

								$(iframe[1]).on('load', function (e) {
									Typer_CustomizerPanel.initialize.initIframe($(this)[0].contentWindow);
								});
							}, 500);
						});
					}
				});
			}

			setTimeout(function () {
				let iframe = document.getElementsByTagName('iframe');

				$(iframe[0]).on('load', function (e) {
					Typer_CustomizerPanel.initialize.initIframe($(this)[0].contentWindow);
				});
			}, 200);
		},
		initIframe: function (iframe) {
			let formats = Typer_CustomizerPanel.formats;
			let controls = Typer_CustomizerPanel.controls;

			$(iframe).on('resize', function (e) {
				for (let i in formats) {
					let size = $('[' + controls.size.selector + '="' + controls.size.slug + '_' + formats[i] + '"' + ']');

					let inherit = $('[' + controls.inherit.selector + '="' + controls.inherit.slug + '_' + formats[i] + '"' + ']');

					if (inherit.is(':checked'))
						return false;

					let height = $('[' + controls.height.selector + '="' + controls.height.slug + '_' + formats[i] + '"' + ']');
					let imageWidth = $('[' + controls.imageWidth.selector + '="' + controls.imageWidth.slug + '_' + formats[i] + '"' + ']');
					let videoWidth = $('[' + controls.videoWidth.selector + '="' + controls.videoWidth.slug + '_' + formats[i] + '"' + ']');
					let galleryWidth = $('[' + controls.galleryWidth.selector + '="' + controls.galleryWidth.slug + '_' + formats[i] + '"' + ']');

					if (size.length) {
						Typer_CustomizerPanel.initialize.triggerChange(size, height, imageWidth, videoWidth, galleryWidth);
					}
				}
			});
		},
		triggerChange: function (size, height, imageWidth, videoWidth, galleryWidth) {
			let current_viewport = wp.customize.previewedDevice.get();
			let val = parseInt(size.val());

			if (current_viewport === 'desktop' && val === 4 ||
				current_viewport === 'tablet' && (val === 4 || val === 3) ||
				current_viewport === 'mobile' && (val === 4 || val === 3 || val === 2)) {
				Typer_CustomizerPanel.initialize.toggleOption(height, false);
				Typer_CustomizerPanel.initialize.toggleOption(imageWidth, false);
				Typer_CustomizerPanel.initialize.toggleOption(videoWidth, false);
				Typer_CustomizerPanel.initialize.toggleOption(galleryWidth, false);
			} else {
				Typer_CustomizerPanel.initialize.toggleOption(height, true);
				Typer_CustomizerPanel.initialize.toggleOption(imageWidth, true);
				Typer_CustomizerPanel.initialize.toggleOption(videoWidth, true);
				Typer_CustomizerPanel.initialize.toggleOption(galleryWidth, true);
			}
		},
		toggleOption: function (option, state) {
			if (option.length)
				Typer_CustomizerPanel.initialize.toggleElement(option.closest('li'), state);
		},
		toggleElement: function (element, state) {
			if (element.length) {
				if (state) {
					element.show();
				} else {
					element.hide();
				}
			}

		},
		initAccordion: function () {
			setTimeout(function () {
				$('.accordion-section').on('click', function () {
					let optionBox = $('#sub-' + $(this).attr('id'));

					if (optionBox.length) {
						$.each(optionBox.find('.acc-toggle'), function (i, accToggle) {
							$(accToggle).on('click', function (e) {
								e.preventDefault();

								let isOpened = $(this).hasClass('is-opened');
								let controlBox = $(this).closest('.customize-control');

								let _this = $(this);
								let start = false;
								$.each(controlBox.parent().find('.customize-control'), function (j, trigger) {
									let self = $(trigger).find('.acc-toggle');

									if (_this.is(self)) {
										start = true;
										return true;
									}

									if (start) {
										if ($(trigger).find('.acc-toggle').length) {
											return false;
										}

										if (isOpened) {
											$(trigger).addClass('hide-control');
										} else {
											$(trigger).removeClass('hide-control');
										}

									}
								});

								$(this).toggleClass('is-opened');
							});

							let controlBox = $(accToggle).closest('.customize-control');

							let _this = $(this);
							let start = false;
							$.each(controlBox.parent().find('.customize-control'), function (j, trigger) {
								let self = $(trigger).find('.acc-toggle');

								if (_this.is(self)) {
									start = true;
									return true;
								}

								if (start) {
									if ($(trigger).find('.acc-toggle').length) {
										return false;
									}
									$(trigger).addClass('hide-control');
								}

							});
						});

						optionBox.find('.acc-toggle').first().trigger('click');
					}
				});
			}, 200);
		},
		initFullscreenSlider: function () {
			$('.viewport-slider').rangeslider({
				polyfill: false,

				rangeClass: 'rangeslider',
				disabledClass: 'rangeslider--disabled',
				horizontalClass: 'rangeslider--horizontal',
				fillClass: 'rangeslider__fill',
				handleClass: 'rangeslider__handle',

				onInit: function () {
					let $rangeEl = this.$range;

					let rangeLabels = this.$element.attr('labels');
					rangeLabels = rangeLabels.split(', ');

					$rangeEl.append('<div class="rangeslider__labels"></div>');
					$(rangeLabels).each(function (index, value) {
						$rangeEl.find('.rangeslider__labels').append('<span class="rangeslider__labels__label">' + value + '</span>');
					});
				}
			});

		},
		initSlider: function () {
			$('.input-rangeslider').rangeslider({
				polyfill: false,

				rangeClass: 'rangeslider',
				disabledClass: 'rangeslider--disabled',
				horizontalClass: 'rangeslider--horizontal',
				fillClass: 'rangeslider__fill',
				handleClass: 'rangeslider__handle',
				onInit: function () {
					let $rangeEl = this.$range;

					$rangeEl.append('<div class="rangeslider__current">' + this.value + 'px</div>');
				},
				onSlide: function (position, value) {
					let $handle = this.$range.find('.rangeslider__current');
					$handle.text(this.value + 'px');
				}
			});
		}
	};

	Typer_CustomizerPanel.documentOnReady = {
		init: function () {
			Typer_CustomizerPanel.initialize.initAccordion();
			Typer_CustomizerPanel.initialize.initFullscreenSlider();
			Typer_CustomizerPanel.initialize.initSlider();
			Typer_CustomizerPanel.initialize.heightOptionWatcher();
		}
	};

	$(document).ready(Typer_CustomizerPanel.documentOnReady.init);

})(jQuery, wp);
