<?php

/**
 * Plugin Name: Typer PRO
 * Description: Adds Pro functionality to Typer Theme
 * Plugin URI: https://seventhqueen.com
 * Author: SeventhQueen
 * Version: 1.7.2
 * Author URI: https://seventhqueen.com
 *
 * Text Domain: typer-pro
 * Domain Path: /languages
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'TYPER_PRO_VERSION', '1.7.2' );

define( 'TYPER_PRO_FILE', __FILE__ );
define( 'TYPER_PRO_PLUGIN_BASE', plugin_basename( TYPER_PRO_FILE ) );
define( 'TYPER_PRO_PATH', plugin_dir_path( TYPER_PRO_FILE ) );
define( 'TYPER_PRO_URL', plugins_url( '/', TYPER_PRO_FILE ) );
define( 'TYPER_PRO_CORE_PATH', TYPER_PRO_PATH . 'core/' );
define( 'TYPER_PRO_ASSETS_URL', TYPER_PRO_URL . 'assets/' );

function typer_pro_load_plugin_textdomain() {
	load_plugin_textdomain( 'typer-pro', false, basename( __DIR__ ) . '/languages/' );
}

add_action( 'plugins_loaded', 'typer_pro_load_plugin_textdomain' );

// Init plugin
require_once TYPER_PRO_CORE_PATH . 'TyperPro.php';
