<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<?php if ( get_option( 'users_can_register' ) ) : ?>

	<form method="POST" action="<?php echo esc_url( $link ); ?>"
	      class="svq-register-form svq-form" name="registration-form" autocomplete="off">

		<p class="form-notice login-alternatives text-center">
			<span><?php esc_html_e( 'Already have an account?', 'typer-pro' ); ?></span>
			<a href="<?php echo wp_login_url() ?>" class="login-popup">
				<span><?php esc_html_e( 'Login here.', 'typer-pro' ); ?></span>
			</a>
		</p>

		<div class="form-group text-center">
			<?php do_action( 'svq_before_register_form_fields' ) ?>
		</div>

		<div class="form-group">
			<input type="text" name="user_login" class="form-control"
			       placeholder="<?php esc_attr_e( 'Choose a username', 'typer-pro' ) ?>" autocomplete="off" required>
		</div>

		<div class="form-group">
			<input type="email" name="user_email" class="form-control"
			       placeholder="<?php esc_attr_e( 'Your email', 'typer-pro' ) ?>" autocomplete="off" required>
		</div>

		<?php do_action( 'svq_after_register_form_fields' ) ?>

		<?php do_action( 'register_form' ); ?>

		<?php if ( $terms_page ) : ?>
			<div class="form-group form-check">
				<label class="form-check-label" for="termsCheckbox">
					<input type="checkbox" name="terms" class="form-check-input" id="termsCheckbox">
					<span class="label-text">
                        <span>
                            <?php echo wp_kses_post( sprintf( __( 'By signing up, I agree with <a href="%s" target="_blank">%s</a>.', 'typer-pro' ), get_permalink( $terms_page ), get_the_title( $terms_page ) ) ) ?>
                        </span>
                    </span>
				</label>
			</div>
		<?php endif; ?>

		<p class="alert alert-warning svq-register-result"></p>

		<?php

		$btn_class = $onboarding ? '' : 'btn-sm';

		?>

		<div class="form-action text-center mt-6">
			<div class="form-group">
				<input type="hidden" name="redirect_to" value=""/>
				<input type="hidden" name="action" value="svq_register">
				<?php wp_nonce_field( 'svq-ajax-register-nonce', 'security-register' ); ?>
				<button type="submit" class="btn <?php echo esc_attr( $btn_class ) ?> btn-dark button-ripple">
					<?php esc_html_e( 'Register', 'typer-pro' ) ?>
					<span class="button_ripple"></span>
				</button>
			</div>
		</div>

	</form>
<?php else: ?>
	<span><?php esc_html_e( 'Registration is closed.', 'typer-pro' ); ?></span>
<?php endif; ?>

