<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Filters the URL redirected to after submitting the lostpassword/retrievepassword form.
 *
 * @param string $lostpassword_redirect The redirect destination URL.
 *
 * @since 3.0.0
 *
 */
$redirect_to = apply_filters( 'lostpassword_redirect', '' );

/**
 * Fires before the lost password form.
 *
 * @since 1.5.1
 */
do_action( 'lost_password' );


do_action( 'svq_before_lost_password_form' );
?>

<form action="<?php echo esc_url( wp_lostpassword_url( $redirect_to ) ); ?>"
      name="lostpasswordform" class="svq-lost-form svq-form" method="POST" autocomplete="off">

	<div class="form-group">
		<input type="text" name="user_login" class="form-control"
		       placeholder="<?php esc_attr_e( 'Username or Email Address', 'typer-pro' ) ?>" autocomplete="off"
		       required>
	</div>

	<?php do_action( 'svq_lost_password_form' ) ?>

	<p class="alert alert-warning svq-forgot-result"></p>

	<div class="form-action text-center mt-8">
		<div class="form-group">

			<?php
			/**
			 * Fires inside the lostpassword form tags, before the hidden fields.
			 *
			 * @since 2.1.0
			 */
			do_action( 'lostpassword_form' ); ?>

			<input type="hidden" name="redirect_to" value="<?php echo esc_attr( $redirect_to ); ?>"/>
			<?php wp_nonce_field( 'svq-ajax-lost-nonce', 'security-lost-pass' ); ?>

			<button type="submit" class="btn btn-sm btn-outline-dark button-ripple">
				<?php esc_html_e( 'Get new password', 'typer-pro' ) ?>
				<span class="button_ripple"></span>
			</button>
		</div>
	</div>
</form>
