<form method="POST" action="<?php echo esc_url( site_url( 'wp-login.php', 'login_post' ) ) ?>"
      class="svq-login-form svq-form" name="registration-form" autocomplete="off">

	<p class="form-notice login-alternatives text-center">
		<?php if ( get_option( 'users_can_register' ) ) : ?>
			<span><?php esc_html_e( 'Don\'t have an account?', 'typer-pro' ); ?></span>
			<a href="<?php echo wp_registration_url() ?>" class="register-popup">
				<span><?php esc_html_e( 'Register now!', 'typer-pro' ); ?></span>
			</a>
		<?php endif; ?>
	</p>

	<div class="form-group text-center">
		<?php do_action( 'svq_before_login_form_fields' ) ?>
	</div>

	<div class="form-group">
		<input type="text" name="log" class="form-control"
		       placeholder="<?php esc_attr_e( 'Username or Email Address', 'typer-pro' ) ?>" autocomplete="off"
		       required>
	</div>

	<div class="form-group">
		<input type="password" name="pwd" class="form-control"
		       placeholder="<?php esc_attr_e( 'Password', 'typer-pro' ) ?>" required>
	</div>

	<?php do_action( 'svq_after_login_form_fields' ) ?>

	<div class="form-check d-flex align-items-center">
		<input name="rememberme" id="svq-login-remember" type="checkbox" value="forever">
		<label for="svq-login-remember" class="form-check-label flex-grow-1">
			<?php esc_html_e( 'Remember Me', 'typer-pro' ); ?>
		</label>
		<span class="form-notice float-right small">
            <a href="<?php echo wp_lostpassword_url() ?>" class="recover-popup">
                <span><?php esc_html_e( 'Lost your password?', 'typer-pro' ); ?></span>
            </a>
      </span>
	</div>

	<?php
	/* Make sure Facebook login button doesn't appear here */
	remove_action( 'login_form', [ SQ_Elements\Modules\Facebook\Component::instance(), 'the_fb_button' ], 10 );
	do_action( 'login_form' );
	add_action( 'login_form', [ SQ_Elements\Modules\Facebook\Component::instance(), 'the_fb_button' ], 10 );
	?>

	<p class="alert alert-warning svq-login-result"></p>

	<div class="form-action text-center mt-6">
		<div class="form-group">
			<input type="hidden" name="redirect_to" value=""/>
			<input type="hidden" name="testcookie" value="1"/>
			<?php wp_nonce_field( 'svq-ajax-login-nonce', 'security-login' ); ?>
			<button type="submit" class="btn btn-sm btn-outline-dark button-ripple">
				<?php esc_html_e( 'Sign in', 'typer-pro' ) ?>
				<span class="button_ripple"></span>
			</button>
		</div>
	</div>
</form>
