<?php

namespace SQ_Elements;
/**
 * Blocks Initializer
 *
 * Enqueue CSS/JS of all the blocks.
 *
 * @since   1.0.0
 * @package TyperPro
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Init {

	public function __construct() {

		// Gutenberg blocks.
		add_action( 'enqueue_block_editor_assets', [ $this, 'native_block_assets' ] );
		add_action( 'enqueue_block_editor_assets', [ $this, 'register_blocks' ] );

		add_filter( 'block_categories', [ $this, 'register_block_category' ], 10, 2 );

		add_action( 'plugins_loaded', [ $this, 'plugins_loaded' ] );

		require_once SQB_GUTEN_EXTRA . 'Notes/Component.php';
	}

	public function plugins_loaded() {

		// Customizer options.
		$this->require_customizer_options();

		// Widgets.
		$this->require_widgets();
		add_action( 'widgets_init', [ $this, 'register_widgets' ] );

		// Modules.
		$this->require_modules();
	}

	private function require_widgets() {
		// Init Widgets
		require_once SQB_WIDGETS . 'Mailchimp/Component.php';
		require_once SQB_WIDGETS . 'Author/Component.php';
		require_once SQB_WIDGETS . 'Social/Component.php';
		require_once SQB_WIDGETS . 'Articles/Component.php';
	}

	private function require_customizer_options() {
		require_once SQB_WIDGETS . 'Mailchimp/CustomizerOptions.php';
	}

	public function register_widgets() {
		register_widget( '\SQ_Elements\Widgets\Mailchimp\Component' );
		register_widget( '\SQ_Elements\Widgets\Author\Component' );
		register_widget( '\SQ_Elements\Widgets\Social\Component' );
		register_widget( '\SQ_Elements\Widgets\Articles\Component' );
	}

	private function require_modules() {
		require_once SQB_MODULES . 'Ajax_Auth/Component.php';
		require_once SQB_MODULES . 'Facebook/Component.php';
		require_once SQB_MODULES . 'PostAutoloader/Component.php';
	}

	public function native_block_assets() {

		wp_register_style(
			'blocks-editor-build',
			SQB_URL . 'dist/blocks.editor.build.css',
			[ 'wp-edit-blocks' ],
			null
		);

		wp_register_script(
			'sq-block-native',
			SQB_URL . 'dist/blocks.native.build.js',
			[
				'wp-blocks',
				'wp-i18n',
				'wp-element',
				'wp-editor'
			],
			null,
			true
		);

		wp_enqueue_style( 'blocks-editor-build' );
		wp_enqueue_script( 'sq-block-native' );
	}

	public function register_blocks() {

		$blocks = [
			'gallery',
			'code',
			'video',
			'audio'
		];

		foreach ( $blocks as $block ) {
			$file = SQB_URL . 'dist/block.' . $block . '.js';

			wp_register_script(
				'svq-block-' . $block,
				$file,
				[
					'wp-blocks',
					'wp-i18n',
					'wp-element',
					'wp-editor'
				],
				null,
				true
			);

			register_block_type(
				'svq/block-' . $block,
				[
					'style'         => 'blocks-style-build',
					'editor_script' => 'svq-block-' . $block,
					'editor_style'  => 'blocks-editor-build',
				]
			);
		}
	}

	public function register_block_category( $categories, $post ) {
		return array_merge(
			$categories,
			array(
				array(
					'slug'  => 'svq-blocks',
					'title' => esc_html__( 'Typer Elements', 'typer-pro' ),
					'icon'  => '',
				),
			)
		);
	}

}

new Init();

