<?php

namespace SQ_Elements;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * @param $name
 * @param array $args
 * @param bool $require_once
 *
 * @return void
 */
function sqe_load_template( $name, $args = [], $require_once = false ) {
	if ( ! $name ) {
		return;
	}

	extract( $args );
	$template_name  = trim( $name );
	$theme_template = locate_template( 'overrides/' . $template_name . '.php' );

	if ( $theme_template ) {
		$template_path = $theme_template;
	} else {
		$template_path = SQB_PATH . 'templates/' . $template_name . '.php';
	}

	if ( $require_once ) {
		require_once $template_path;
	} else {
		include $template_path;
	}
}


if ( ! function_exists( 'svq_option' ) ) {
	/**
	 * Helper function to get customizer settings
	 *
	 * @param bool $option
	 * @param bool $default
	 * @param bool $filters
	 *
	 * @return bool|mixed|null
	 */
	function svq_option( $option = false, $default = false, $filters = false ) {
		if ( $option === false ) {
			return false;
		}
		$svq_options = get_theme_mods();

		if ( isset( $svq_options[ $option ] ) && $svq_options[ $option ] !== '' ) {
			$output_data = $svq_options[ $option ];
		} else {
			$output_data = $default;
		}

		if ( $filters === true ) {
			$output_data = apply_filters( 'svq_option', $output_data, $option );
		}

		return $output_data;
	}
}
