<?php

namespace SQ_Elements\Widgets\Social;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Component extends \WP_Widget {

	public function __construct() {
		$widget_ops = [
			'description' => esc_html__( 'Typer Social Links.', 'typer-pro' )
		];

		parent::__construct(
			'sq_social_links',
			esc_html__( 'Typer Social Links', 'typer-pro' ),
			$widget_ops
		);
	}

	public function widget( $args, $instance ) {
		echo $args['before_widget'];

		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}

		$open_blank = isset( $instance['open_blank'] ) ? $instance['open_blank'] : '';

		$target = 'target=_self';

		if ( $open_blank ) {
			$target = 'target=_blank';
		}

		?>

		<div class="svq-share">
			<div class="svq-share__action div-lower" role="group">
				<?php if ( isset( $instance['facebook'] ) && $instance['facebook'] ): ?>
					<a class="btn btn-link social-facebook" <?php echo esc_attr( $target ); ?>
					   href="<?php echo esc_url( $instance['facebook'] ) ?>">
						<span class="svq-icon icon-facebook icon--x18"></span>
					</a>
				<?php endif; ?>

				<?php if ( isset( $instance['twitter'] ) && $instance['twitter'] ): ?>
					<a class="btn btn-link social-twitter" <?php echo esc_attr( $target ); ?>
					   href="<?php echo esc_url( $instance['twitter'] ) ?>">
						<span class="svq-icon icon-twitter icon--x18"></span>
					</a>
				<?php endif; ?>

				<?php if ( isset( $instance['instagram'] ) && $instance['instagram'] ): ?>
					<a class="btn btn-link social-instagram" <?php echo esc_attr( $target ); ?>
					   href="<?php echo esc_url( $instance['instagram'] ) ?>">
						<span class="svq-icon icon-instagram icon--x18"></span>
					</a>
				<?php endif; ?>

				<?php if ( isset( $instance['pinterest'] ) && $instance['pinterest'] ): ?>
					<a class="btn btn-link social-pinterest" <?php echo esc_attr( $target ); ?>
					   href="<?php echo esc_url( $instance['pinterest'] ) ?>">
						<span class="svq-icon icon-pinterest icon--x18"></span>
					</a>
				<?php endif; ?>

				<?php if ( isset( $instance['youtube'] ) && $instance['youtube'] ): ?>
					<a class="btn btn-link social-youtube" <?php echo esc_attr( $target ); ?>
					   href="<?php echo esc_url( $instance['youtube'] ) ?>">
						<span class="svq-icon icon-youtube icon--x18"></span>
					</a>
				<?php endif; ?>
			</div>
		</div>

		<?php

		echo $args['after_widget'];

	}

	public function update( $new_instance, $old_instance ) {
		$instance['title']      = isset( $new_instance['title'] ) ? strip_tags( stripslashes( $new_instance['title'] ) ) : '';
		$instance['facebook']   = isset( $new_instance['facebook'] ) ? strip_tags( stripslashes( $new_instance['facebook'] ) ) : '';
		$instance['twitter']    = isset( $new_instance['twitter'] ) ? strip_tags( stripslashes( $new_instance['twitter'] ) ) : '';
		$instance['instagram']  = isset( $new_instance['instagram'] ) ? strip_tags( stripslashes( $new_instance['instagram'] ) ) : '';
		$instance['pinterest']  = isset( $new_instance['pinterest'] ) ? strip_tags( stripslashes( $new_instance['pinterest'] ) ) : '';
		$instance['youtube']    = isset( $new_instance['youtube'] ) ? strip_tags( stripslashes( $new_instance['youtube'] ) ) : '';
		$instance['open_blank'] = isset( $new_instance['open_blank'] ) ? strip_tags( stripslashes( $new_instance['open_blank'] ) ) : '';

		return $instance;
	}

	public function form( $instance ) {
		$title      = isset( $instance['title'] ) ? $instance['title'] : '';
		$facebook   = isset( $instance['facebook'] ) ? $instance['facebook'] : '';
		$twitter    = isset( $instance['twitter'] ) ? $instance['twitter'] : '';
		$instagram  = isset( $instance['instagram'] ) ? $instance['instagram'] : '';
		$pinterest  = isset( $instance['pinterest'] ) ? $instance['pinterest'] : '';
		$youtube    = isset( $instance['youtube'] ) ? $instance['youtube'] : '';
		$open_blank = isset( $instance['open_blank'] ) ? $instance['open_blank'] : '';

		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">
				<?php esc_html_e( 'Title:', 'typer-pro' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
			       name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $title; ?>"/>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'facebook' ); ?>">
				<?php esc_html_e( 'Facebook URL:', 'typer-pro' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'facebook' ); ?>"
			       name="<?php echo $this->get_field_name( 'facebook' ); ?>" value="<?php echo $facebook; ?>"/>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'twitter' ); ?>">
				<?php esc_html_e( 'Twitter URL:', 'typer-pro' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'twitter' ); ?>"
			       name="<?php echo $this->get_field_name( 'twitter' ); ?>" value="<?php echo $twitter; ?>"/>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'instagram' ); ?>">
				<?php esc_html_e( 'Instagram URL:', 'typer-pro' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'instagram' ); ?>"
			       name="<?php echo $this->get_field_name( 'instagram' ); ?>" value="<?php echo $instagram; ?>"/>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'pinterest' ); ?>">
				<?php esc_html_e( 'Pinterest URL:', 'typer-pro' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'pinterest' ); ?>"
			       name="<?php echo $this->get_field_name( 'pinterest' ); ?>" value="<?php echo $pinterest; ?>"/>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'youtube' ); ?>">
				<?php esc_html_e( 'Youtube URL:', 'typer-pro' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'youtube' ); ?>"
			       name="<?php echo $this->get_field_name( 'youtube' ); ?>" value="<?php echo $youtube; ?>"/>
		</p>

		<p>
			<input class="checkbox" type="checkbox" id="<?php echo $this->get_field_name( 'open_blank' ); ?>"
			       name="<?php echo $this->get_field_name( 'open_blank' ); ?>"
			       value="yes" <?php checked( $open_blank, 'yes' ); ?>>
			<label
				for="<?php echo $this->get_field_name( 'open_blank' ); ?>"><?php _e( 'Open in a new tab?', 'typer' ); ?></label>
		</p>

		<?php
	}
}
