<?php

namespace SQ_Elements\Widgets\Mailchimp;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class CustomizerOptions
 * @package FUP
 */
class CustomizerOptions {

	/**
	 * @var null
	 */
	public static $instance = null;

	/**
	 * @return CustomizerOptions|null
	 */
	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * FupPlugin constructor.
	 */
	public function __construct() {
		add_filter( 'typer_theme_settings', [ $this, 'settings' ], 20, 2 );
	}

	/**
	 * @param $sq
	 * @param $panel
	 *
	 * @return mixed
	 */
	public function settings( $sq, $panel ) {
		$section = 'mailchimp_api';

		$sq['sec'][ $section ] = [
			'title'    => esc_html__( 'MailChimp Widget Settings', 'fup' ),
			'panel'    => $panel,
			'priority' => 1002
		];

		$sq['set'][ $section ] = [
			'section' => $section,
			'type'    => 'text',
			'title'   => esc_html__( 'MailChimp API Key', 'typer-pro' )
		];

		return $sq;
	}
}

CustomizerOptions::instance();
