<?php

namespace SQ_Elements\Widgets\Author;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Component extends \WP_Widget {

	public function __construct() {
		$widget_ops = [
			'description' => esc_html__( 'Shows author box on single post.', 'typer-pro' )
		];

		parent::__construct(
			'sq_author',
			esc_html__( 'Typer Author Box', 'typer-pro' ),
			$widget_ops
		);
	}

	public function widget( $args, $instance ) {
		if ( is_super_admin() && ! is_single() ) {
			echo '<p class="alert alert-warning" role="alert">' . esc_html__( 'Notice! This widget will only show up on single post pages.', 'typer-pro' ) . '</p>';

			return;
		}

		if ( is_super_admin() && ! class_exists( '\FUP\FupPlugin' ) ) {
			echo '<p class="alert alert-warning" role="alert">' . esc_html__( 'Warning! This widget requires the Front User Profile plugin.', 'typer-pro' ) . '</p>';

			return;
		}

		if ( ! is_single() ) {
			return;
		}

		echo $args['before_widget'];

		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}

		echo do_shortcode( '[sq-author-box]' );

		echo $args['after_widget'];

	}

	public function update( $new_instance, $old_instance ) {
		$instance['title'] = isset( $new_instance['title'] ) ? strip_tags( stripslashes( $new_instance['title'] ) ) : '';

		return $instance;
	}

	public function form( $instance ) {
		$title = isset( $instance['title'] ) ? $instance['title'] : '';

		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">
				<?php esc_html_e( 'Title:', 'typer-pro' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
			       name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $title; ?>"/>
		</p>

		<?php
	}
}
