<?php

namespace SQ_Elements\Widgets\Articles;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use function SQ_Elements\sqe_load_template;

class Component extends \WP_Widget {

	public function __construct() {
		parent::__construct(
			'sq_articles',
			esc_html__( 'Typer Articles', 'typer-pro' ),
			[
				'classname'   => 'sq_articles_type',
				'description' => esc_html__( 'Articles list.', 'typer-pro' )
			]
		);
	}

	public function widget( $args, $instance ) {
		$instance['source']           = isset( $instance['source'] ) ? strip_tags( stripslashes( $instance['source'] ) ) : 'latest';
		$instance['query_max_posts']  = isset( $instance['query_max_posts'] ) ? (int) strip_tags( stripslashes( $instance['query_max_posts'] ) ) : 5;
		$instance['query_category']   = isset( $instance['query_category'] ) ? strip_tags( stripslashes( $instance['query_category'] ) ) : '0';
		$instance['query_tag']        = isset( $instance['query_tag'] ) ? strip_tags( stripslashes( $instance['query_tag'] ) ) : '0';
		$instance['query_offset']     = isset( $instance['query_offset'] ) ? strip_tags( stripslashes( $instance['query_offset'] ) ) : '0';
		$instance['include_sticky']   = isset( $instance['include_sticky'] ) ? strip_tags( stripslashes( $instance['include_sticky'] ) ) : '1';
		$instance['image_position']   = isset( $instance['image_position'] ) ? strip_tags( stripslashes( $instance['image_position'] ) ) : '1';
		$instance['show_excerpt']     = isset( $instance['show_excerpt'] ) ? strip_tags( stripslashes( $instance['show_excerpt'] ) ) : '1';
		$instance['show_category']    = isset( $instance['show_category'] ) ? strip_tags( stripslashes( $instance['show_category'] ) ) : '1';
		$instance['show_meta_author'] = isset( $instance['show_meta_author'] ) ? strip_tags( stripslashes( $instance['show_meta_author'] ) ) : '1';
		$instance['show_meta_date']   = isset( $instance['show_meta_date'] ) ? strip_tags( stripslashes( $instance['show_meta_date'] ) ) : '1';

		if ( $instance['source'] === 'liked' && is_super_admin() && ! class_exists( '\FUP\FupPlugin' ) ) {
			echo '<p class="alert alert-warning" role="alert">' . esc_html__( 'Warning! To show the most liked articles you need to install and enable the Front User Profile plugin. By default, this widget will show the latest articles if you don\'t have the previous mentioned plugin enabled.', 'typer-pro' ) . '</p>';
		}

		$query_args = [
			'post_type'      => 'post',
			'post_status'    => [ 'publish' ],
			'posts_per_page' => $instance['query_max_posts'],
			'offset'         => $instance['query_offset'],
		];

		if ( $instance['query_category'] && get_category( $instance['query_category'] ) && ! is_wp_error( get_category( $instance['query_category'] ) ) ) {
			$query_args['category__in'] = [ $instance['query_category'] ];
		}

		if ( $instance['query_tag'] && get_tag( $instance['query_tag'] ) && ! is_wp_error( get_tag( $instance['query_tag'] ) ) ) {
			$query_args['tag__in'] = [ $instance['query_tag'] ];
		}

		if ( ! $instance['include_sticky'] ) {
			$query_args['ignore_sticky_posts'] = 1;
		}

		if ( $instance['source'] === 'liked' && class_exists( '\FUP\FupPlugin' ) ) {
			$liked_posts     = fup_get_most_liked_posts( $instance['query_max_posts'] );
			$liked_posts_ids = [];

			foreach ( $liked_posts as $liked_post ) {
				$liked_posts_ids[] = $liked_post->target_id;
			}

			$query_args['post__in'] = $liked_posts_ids;
		}

		$query = new \WP_Query( $query_args );

		$args['before_widget'] = str_replace( 'sq_articles_type', 'svq-articles-' . $instance['source'], $args['before_widget'] );

		echo $args['before_widget'];

		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}

		if ( ! $query->have_posts() ) {
			echo esc_html__( 'There are no matching posts for this section.', 'typer-pro' );
		} else {
			echo '<div class="svq-article--list svq-article--widget">';

			while ( $query->have_posts() ) {
				$query->the_post();

				sqe_load_template( 'widgets/articles', $instance );
			}

			echo '</div>';
		}

		echo $args['after_widget'];

		wp_reset_postdata();
	}

	public function update( $new_instance, $old_instance ) {
		$instance                     = [];
		$instance['title']            = isset( $new_instance['title'] ) ? strip_tags( stripslashes( $new_instance['title'] ) ) : '';
		$instance['source']           = isset( $new_instance['source'] ) ? strip_tags( stripslashes( $new_instance['source'] ) ) : 'latest';
		$instance['query_max_posts']  = isset( $new_instance['query_max_posts'] ) ? (int) strip_tags( stripslashes( $new_instance['query_max_posts'] ) ) : 5;
		$instance['query_category']   = isset( $new_instance['query_category'] ) ? (int) strip_tags( stripslashes( $new_instance['query_category'] ) ) : 0;
		$instance['query_tag']        = isset( $new_instance['query_tag'] ) ? (int) strip_tags( stripslashes( $new_instance['query_tag'] ) ) : 0;
		$instance['query_offset']     = isset( $new_instance['query_offset'] ) ? (int) strip_tags( stripslashes( $new_instance['query_offset'] ) ) : 0;
		$instance['include_sticky']   = isset( $new_instance['include_sticky'] ) ? strip_tags( stripslashes( $new_instance['include_sticky'] ) ) : '1';
		$instance['image_position']   = isset( $new_instance['image_position'] ) ? strip_tags( stripslashes( $new_instance['image_position'] ) ) : '1';
		$instance['show_excerpt']     = isset( $new_instance['show_excerpt'] ) ? strip_tags( stripslashes( $new_instance['show_excerpt'] ) ) : '1';
		$instance['show_category']    = isset( $new_instance['show_category'] ) ? strip_tags( stripslashes( $new_instance['show_category'] ) ) : '1';
		$instance['show_meta_author'] = isset( $new_instance['show_meta_author'] ) ? strip_tags( stripslashes( $new_instance['show_meta_author'] ) ) : '1';
		$instance['show_meta_date']   = isset( $new_instance['show_meta_date'] ) ? strip_tags( stripslashes( $new_instance['show_meta_date'] ) ) : '1';

		return $instance;
	}

	public function form( $instance ) {
		$title            = isset( $instance['title'] ) ? $instance['title'] : '';
		$source           = isset( $instance['source'] ) ? $instance['source'] : 'latest';
		$query_max_posts  = isset( $instance['query_max_posts'] ) ? $instance['query_max_posts'] : 5;
		$query_category   = isset( $instance['query_category'] ) ? $instance['query_category'] : 0;
		$query_tag        = isset( $instance['query_tag'] ) ? $instance['query_tag'] : 0;
		$query_offset     = isset( $instance['query_offset'] ) ? $instance['query_offset'] : 0;
		$include_sticky   = isset( $instance['include_sticky'] ) ? $instance['include_sticky'] : '1';
		$image_position   = isset( $instance['image_position'] ) ? $instance['image_position'] : '1';
		$show_excerpt     = isset( $instance['show_excerpt'] ) ? $instance['show_excerpt'] : '1';
		$show_category    = isset( $instance['show_category'] ) ? $instance['show_category'] : '1';
		$show_meta_author = isset( $instance['show_meta_author'] ) ? $instance['show_meta_author'] : '1';
		$show_meta_date   = isset( $instance['show_meta_date'] ) ? $instance['show_meta_date'] : '1';

		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">
				<?php esc_html_e( 'Title:', 'typer-pro' ); ?>
			</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
			       name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $title; ?>"/>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'source' ); ?>">
				<?php esc_html_e( 'Show:', 'typer-pro' ); ?>
			</label>
			<select id="<?php echo $this->get_field_id( 'source' ); ?>"
			        name="<?php echo $this->get_field_name( 'source' ); ?>">
				<option <?php echo( $source === 'latest' ? 'selected="selected"' : '' ) ?> value="latest">
					<?php esc_html_e( 'Latest articles' ); ?>
				</option>
				<option <?php echo( $source === 'liked' ? 'selected="selected"' : '' ) ?> value="liked">
					<?php esc_html_e( 'Most liked' ); ?>
				</option>
			</select>
		</p>

		<?php

		$categoryArray   = [];
		$categoryArray[] = esc_html__( 'All', 'typer-pro' );
		$categories      = get_categories( 'orderby=name&hide_empty=0' );

		foreach ( $categories as $category ) {
			$categoryArray[ $category->term_id ] = $category->name;
		}

		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'query_category' ); ?>">
				<?php esc_html_e( 'From category:', 'typer-pro' ); ?>
			</label>
			<select id="<?php echo $this->get_field_id( 'query_category' ); ?>"
			        name="<?php echo $this->get_field_name( 'query_category' ); ?>">
				<?php foreach ( $categoryArray as $id => $name ) : ?>
					<option <?php echo( $query_category === (int) $id ? 'selected="selected"' : '' ) ?>
						value="<?php echo esc_attr( $id ) ?>">
						<?php echo esc_html( $name ) ?>
					</option>
				<?php endforeach; ?>
			</select>
		</p>

		<?php

		$tagArray   = [];
		$tagArray[] = esc_html__( 'All', 'typer-pro' );
		$tags       = get_tags( array(
			'hide_empty' => false
		) );

		foreach ( $tags as $tag ) {
			$tagArray[ $tag->term_id ] = $tag->name;
		}

		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'query_tag' ); ?>">
				<?php esc_html_e( 'From tag:', 'typer-pro' ); ?>
			</label>
			<select id="<?php echo $this->get_field_id( 'query_tag' ); ?>"
			        name="<?php echo $this->get_field_name( 'query_tag' ); ?>">
				<?php foreach ( $tagArray as $id => $name ) : ?>
					<option <?php echo( $query_tag === (int) $id ? 'selected="selected"' : '' ) ?>
						value="<?php echo esc_attr( $id ) ?>">
						<?php echo esc_html( $name ) ?>
					</option>
				<?php endforeach; ?>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'query_max_posts' ); ?>">
				<?php esc_html_e( 'Max posts:', 'typer-pro' ); ?>
			</label>
			<input type="number" id="<?php echo $this->get_field_id( 'query_max_posts' ); ?>"
			       name="<?php echo $this->get_field_name( 'query_max_posts' ); ?>"
			       value="<?php echo $query_max_posts; ?>"/>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'query_offset' ); ?>">
				<?php esc_html_e( 'Offset:', 'typer-pro' ); ?>
			</label>
			<input type="number" id="<?php echo $this->get_field_id( 'query_offset' ); ?>"
			       name="<?php echo $this->get_field_name( 'query_offset' ); ?>"
			       value="<?php echo $query_offset; ?>"/>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'include_sticky' ); ?>">
				<?php esc_html_e( 'Include sticky posts:', 'typer-pro' ); ?>
			</label>
			<select id="<?php echo $this->get_field_id( 'include_sticky' ); ?>"
			        name="<?php echo $this->get_field_name( 'include_sticky' ); ?>">
				<option <?php echo( $include_sticky === '1' ? 'selected="selected"' : '' ) ?> value="1">
					<?php esc_html_e( 'Yes' ); ?>
				</option>
				<option <?php echo( $include_sticky === '0' ? 'selected="selected"' : '' ) ?> value="0">
					<?php esc_html_e( 'No' ); ?>
				</option>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'image_position' ); ?>">
				<?php esc_html_e( 'Image Position:', 'typer-pro' ); ?>
			</label>
			<select id="<?php echo $this->get_field_id( 'image_position' ); ?>"
			        name="<?php echo $this->get_field_name( 'image_position' ); ?>">
				<option <?php echo( $image_position === '1' ? 'selected="selected"' : '' ) ?> value="1">
					<?php esc_html_e( 'Right' ); ?>
				</option>
				<option <?php echo( $image_position === '0' ? 'selected="selected"' : '' ) ?> value="0">
					<?php esc_html_e( 'Left' ); ?>
				</option>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'show_excerpt' ); ?>">
				<?php esc_html_e( 'Show excerpt:', 'typer-pro' ); ?>
			</label>
			<select id="<?php echo $this->get_field_id( 'show_excerpt' ); ?>"
			        name="<?php echo $this->get_field_name( 'show_excerpt' ); ?>">
				<option <?php echo( $show_excerpt === '1' ? 'selected="selected"' : '' ) ?> value="1">
					<?php esc_html_e( 'Yes' ); ?>
				</option>
				<option <?php echo( $show_excerpt === '0' ? 'selected="selected"' : '' ) ?> value="0">
					<?php esc_html_e( 'No' ); ?>
				</option>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'show_category' ); ?>">
				<?php esc_html_e( 'Show category:', 'typer-pro' ); ?>
			</label>
			<select id="<?php echo $this->get_field_id( 'show_category' ); ?>"
			        name="<?php echo $this->get_field_name( 'show_category' ); ?>">
				<option <?php echo( $show_category === '1' ? 'selected="selected"' : '' ) ?> value="1">
					<?php esc_html_e( 'Yes' ); ?>
				</option>
				<option <?php echo( $show_category === '0' ? 'selected="selected"' : '' ) ?> value="0">
					<?php esc_html_e( 'No' ); ?>
				</option>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'show_meta_author' ); ?>">
				<?php esc_html_e( 'Meta author:', 'typer-pro' ); ?>
			</label>
			<select id="<?php echo $this->get_field_id( 'show_meta_author' ); ?>"
			        name="<?php echo $this->get_field_name( 'show_meta_author' ); ?>">
				<option <?php echo( $show_meta_author === '1' ? 'selected="selected"' : '' ) ?> value="1">
					<?php esc_html_e( 'Yes' ); ?>
				</option>
				<option <?php echo( $show_meta_author === '0' ? 'selected="selected"' : '' ) ?> value="0">
					<?php esc_html_e( 'No' ); ?>
				</option>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'show_meta_date' ); ?>">
				<?php esc_html_e( 'Meta date:', 'typer-pro' ); ?>
			</label>
			<select id="<?php echo $this->get_field_id( 'show_meta_date' ); ?>"
			        name="<?php echo $this->get_field_name( 'show_meta_date' ); ?>">
				<option <?php echo( $show_meta_date === '1' ? 'selected="selected"' : '' ) ?> value="1">
					<?php esc_html_e( 'Yes' ); ?>
				</option>
				<option <?php echo( $show_meta_date === '0' ? 'selected="selected"' : '' ) ?> value="0">
					<?php esc_html_e( 'No' ); ?>
				</option>
			</select>
		</p>

		<?php
	}

}
