<?php

namespace SQ_Elements\Modules\PostAutoloader;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use function SQ_Elements\svq_option;

/**
 * Class Autoloader
 * @package TyperPro\PostAutoload
 */
class Component {

	/**
	 * @var null
	 */
	public static $instance;

	/**
	 * @return Component|null
	 */
	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Autoloader constructor.
	 */
	public function __construct() {

		add_action( 'init', [ $this, 'init' ] );

	}

	public function init() {
		$init = (bool) svq_option( 'blog_autoload_next_post_general' );

		if ( isset( $_GET['customize_theme'] ) ) {
			$init = false;
		}

		if ( class_exists( '\Elementor\Plugin' ) && is_callable( '\Elementor\Plugin', 'instance' ) && \Elementor\Plugin::instance()->editor->is_edit_mode() ) {
			$init = false;
		}

		if ( $init ) {
			add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ] );
			add_filter( 'typer_main_attributes', [ $this, 'add_autoload_data' ] );
		}
	}

	public function add_autoload_data( $atts ) {
		$prev_post = get_previous_post();

		if ( $prev_post ) {
			$atts['data-next-url'] = get_permalink( $prev_post );
		}
		$atts['data-url']   = get_permalink();
		$atts['data-title'] = wp_get_document_title();


		return $atts;
	}

	public function enqueue_scripts() {
		if ( ! is_single() ) {
			return;
		}

		wp_register_script(
			'typer-post-autoload',
			SQB_ASSETS_URL . 'js/post-autoload.js',
			[ 'jquery' ],
			TYPER_PRO_VERSION,
			true
		);

		wp_enqueue_script( 'typer-post-autoload' );
	}

}

Component::instance();
