<?php

namespace SQ_Elements\Modules\Facebook;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use function SQ_Elements\svq_option;

/**
 * Class Component
 */
class Component {

	/**
	 * @var null
	 */
	public static $instance = null;

	/**
	 * @return Component|null
	 */
	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * FacebookAuth constructor.
	 */
	public function __construct() {
		add_action( 'template_notices', [ $this, 'fb_register_message' ] );

		add_filter( 'typer_theme_settings', [ $this, 'social_login_settings' ], 10, 2 );

		if ( svq_option( 'facebook_login', false ) ) {
			add_action( 'svq_after_body', [ $this, 'fb_social_head' ] );
			add_action( 'login_head', [ $this, 'fb_social_head' ] );
			add_action( 'login_head', [ $this, 'fb_script' ] );
			add_action( 'wp_footer', [ $this, 'fb_social_footer' ], 99 );
			add_action( 'login_footer', [ $this, 'fb_social_footer' ], 99 );

			if ( ! is_admin() ) {
				add_action( 'init', [ $this, 'fb_init' ] );
			}

			add_action( 'bp_before_login_widget_loggedout', [ $this, 'the_fb_button' ] );
			add_action( 'login_form', [ $this, 'the_fb_button' ], 10 );

			add_action( 'svq_before_login_form_fields', [ $this, 'the_fb_button' ], 12 );
			add_action( 'svq_before_login_form_fields', [ $this, 'social_or' ], 14 );

			if ( svq_option( 'facebook_register', false ) && get_option( 'users_can_register' ) ) {
				add_action( 'bp_before_register_page', [ $this, 'the_fb_button' ] );
				add_action( 'fb_register_action', [ $this, 'fb_register_activity' ] );

				add_action( 'svq_before_register_form_fields', [ $this, 'the_fb_button' ], 12 );
				add_action( 'svq_before_register_form_fields', [ $this, 'social_or' ], 14 );
			}
		}
	}

	/**
	 * Register customizer settings via Kirki
	 *
	 * @param $sq
	 * @param $panel
	 *
	 * @return mixed
	 */
	public function social_login_settings( $sq = [], $panel = '' ) {
		$section = 'svq_section_auth';

		$sq['set']['facebook_login'] = [
			'section'     => $section,
			'type'        => 'switch',
			'default'     => '0',
			'title'       => esc_html__( 'Enable Facebook Login', 'typer-pro' ),
			'description' => esc_html__( 'Allow users to login with Facebook', 'typer-pro' )
		];

		$sq['set']['fb_app_id'] = [
			'section'         => $section,
			'type'            => 'text',
			'default'         => '',
			'title'           => esc_html__( 'Facebook APP ID', 'typer-pro' ),
			'description'     => esc_html__( 'Enter you Facebook APP ID', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'facebook_login',
					'value'   => true,
				]
			]
		];

		$sq['set']['facebook_register'] = [
			'section'         => $section,
			'type'            => 'switch',
			'default'         => '0',
			'title'           => esc_html__( 'Enable registering with Facebook', 'typer-pro' ),
			'description'     => esc_html__( 'Allow users to register with Facebook', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'facebook_login',
					'value'   => true,
				]
			]
		];

		$sq['set']['fb_register_redirect'] = [
			'section'         => $section,
			'type'            => 'select',
			'choices'         => [
				'default' => 'Default',
				'reload'  => 'Reload',
				'custom'  => 'Custom link'
			],
			'default'         => 'reload',
			'title'           => esc_html__( 'Register Redirect', 'typer-pro' ),
			'description'     => esc_html__( 'Default: Goes to user profile. Reload: will reload current page.', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'facebook_login',
					'value'   => true,
				]
			]
		];

		$sq['set']['fb_register_redirect_url'] = [
			'section'         => $section,
			'type'            => 'text',
			'default'         => '',
			'title'           => esc_html__( 'Custom link redirect', 'typer-pro' ),
			'description'     => wp_kses( __( 'Set a link like http(s)://yoursite.com/homepage for users to get redirected on register.', 'typer-pro' ), [ 'br' => [] ] ),
			'active_callback' => [
				[
					'setting' => 'facebook_login',
					'value'   => true,
				],
				[
					'setting'  => 'fb_register_redirect',
					'operator' => '==',
					'value'    => 'custom',
				]
			]
		];

		return $sq;
	}

	/**
	 * @return void|string
	 */
	public function fb_social_head() {
		if ( is_user_logged_in() ) {
			return;
		}

		?>
		<div id="fb-root"></div>
		<?php
	}

	/**
	 * Adds fb scripts to footer
	 */
	public function fb_social_footer() {
		if ( is_user_logged_in() ) {
			return;
		}

		?>
		<script>
			// Additional JS functions here
			window.fbAsyncInit = function() {
				FB.init({
					appId: '<?php echo svq_option( 'fb_app_id' ); ?>', // App ID
					version: 'v3.1',
					status: true, // check login status
					cookie: true, // enable cookies to allow the server to access the session
					xfbml: true,  // parse XFBML
					//oauth: true
				});

				// Additional init code here
				jQuery('body').trigger('svq_fb.init');
			};

			// Load the SDK asynchronously
			(function(d, s, id) {
				var js, fjs = d.getElementsByTagName(s)[0];
				if (d.getElementById(id)) return;
				js = d.createElement(s);
				js.id = id;
				js.src = "//connect.facebook.net/<?php echo apply_filters( 'svq_facebook_js_locale', 'en_US' ); ?>/sdk.js";
				fjs.parentNode.insertBefore(js, fjs);
			}(document, 'script', 'facebook-jssdk'));

			var fbAjaxUrl = '<?php echo site_url( 'wp-login.php', 'login_post' ); ?>';

			window.addEventListener('DOMContentLoaded', function() {
				jQuery(document).ready(function() {

					jQuery('.svq-facebook-connect').on('click', function() {

						/* fix iOS Chrome */
						if (navigator.userAgent.match('CriOS')) {
							window.open(
								'https://www.facebook.com/dialog/oauth?client_id=<?php echo svq_option( 'fb_app_id' ); ?>' +
								+'&redirect_uri=<?php echo esc_url( home_url( '/') ); ?>&scope=email&response_type=token', '', null);
						} else {
							FB.login(function(FB_response) {
									if (FB_response.authResponse) {
										fb_intialize(FB_response, '');
									}
								},
								{
									scope: 'email',
									auth_type: 'rerequest',
									return_scopes: true,
								});
						}

					});

					jQuery('body').on('svq_fb.init', function() {
						var accToken = jQuery.getUrlVar('#access_token');
						if (accToken) {
							var fbArr = {scopes: 'email'};
							fb_intialize(fbArr, accToken);
						}
					});

				});

				jQuery.extend({
					getUrlVars: function() {
						var vars = [], hash;
						var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
						for (var i = 0; i < hashes.length; i++) {
							hash = hashes[i].split('=');
							vars.push(hash[0]);
							vars[hash[0]] = hash[1];
						}
						return vars;
					},
					getUrlVar: function(name) {
						return jQuery.getUrlVars()[name];
					},
				});

			});

			function fb_intialize(FB_response, token) {
				FB.api('/me', 'GET', {
						fields: 'id,email,name',
						access_token: token,
					},
					function(FB_userdata) {
						jQuery.ajax({
							type: 'POST',
							url: fbAjaxUrl,
							data: {
								'action': 'fb_intialize',
								'FB_userdata': FB_userdata,
								'FB_response': FB_response,
								'category': JSON.stringify(localStorage.getItem('category')),
							},
							success: function(user) {
								if (user.error) {
									alert(user.error);
								} else if (user.loggedin) {
									jQuery('.svq-login-result').html(user.message);

									if (window.location.href.indexOf('wp-login.php') > -1) {
										window.location = user.url;
									} else if (user.redirectType == 'reload') {
										window.location.reload();
									} else {
										window.location = user.url;
									}

								}
							},
						});
					},
				);
			}
		</script>
		<?php
	}

	/**
	 * Adds jquery & fb btn styles
	 */
	public function fb_script() {
		//Enqueue jQuery
		wp_enqueue_script( 'jquery' );

		//Output CSS
		echo '<style type="text/css" media="screen">
	    .svq-facebook-connect.btn {
	      display:block;
	      background-color: #4469B0;
	      color: #fff;
	      border-radius: 2px;
	      font-size: 13px;
	      font-weight: normal;
	      margin: 3px 0;
	      min-width: 80px;
	      transition: all 0.4s ease-in-out 0s;
	      cursor: pointer;
	      line-height: 1.42857;
	      padding: 6px 12px;
	      text-align: center;
	      text-decoration: none;
	      vertical-align: middle;
	      white-space: nowrap;
	    }
		</style>';
	}

	/**
	 * Handles fb post request
	 *
	 * @return bool
	 */
	public function fb_init() {
		/* If not our action, bail out */
		if ( ! isset( $_POST['action'] ) || ( isset( $_POST['action'] ) && $_POST['action'] !== 'fb_intialize' ) ) {
			return false;
		}

		header( 'Content-type: application/json' );

		if ( is_user_logged_in() ) {
			die( wp_json_encode( [ 'error' => esc_html__( 'You are already logged in.', 'typer-pro' ) ] ) );
		}

		if ( ! isset( $_REQUEST['FB_response'], $_REQUEST['FB_userdata'] ) ) {
			die( wp_json_encode( [ 'error' => esc_html__( 'Authentication required.', 'typer-pro' ) ] ) );
		}

		$FB_response = $_REQUEST['FB_response'];
		$FB_userdata = $_REQUEST['FB_userdata'];
		$FB_userid   = $FB_userdata['id'];

		if ( ! $FB_userid ) {
			die( wp_json_encode( [ 'error' => esc_html__( 'Please connect your facebook account.', 'typer-pro' ) ] ) );
		}

		global $wpdb;
		//check if we already have matched our facebook account
		$user_ID = $wpdb->get_var( "SELECT user_id FROM $wpdb->usermeta WHERE meta_key = '_fbid' AND meta_value = '$FB_userid'" );

		$redirect      = '';
		$redirect_type = 'redirect';

		//if facebook is not connected
		if ( ! $user_ID ) {
			$user_email = $FB_userdata['email'];
			$user_ID    = $wpdb->get_var( "SELECT ID FROM $wpdb->users WHERE user_email = '" . esc_sql( $user_email ) . "'" );

			//Register user
			if ( ! $user_ID ) {
				if ( ! get_option( 'users_can_register' ) ) {
					die( wp_json_encode( [ 'error' => esc_html__( 'Registration is not open at this time. Please come back later.', 'typer-pro' ) ] ) );
				}
				if ( ! svq_option( 'facebook_register', 0 ) ) {
					die( wp_json_encode( [ 'error' => esc_html__( 'Registration using Facebook is not currently allowed. Please use our Register page', 'typer-pro' ) ] ) );
				}

				extract( $FB_userdata );

				$display_name = $name;

				$first_name = '';
				$last_name  = '';
				$name_array = explode( ' ', $name, 2 );
				$first_name = $name_array[0];
				if ( isset( $name_array[1] ) ) {
					$last_name = $name_array[1];
				}

				$user_email = $email;
				if ( empty( $user_email ) ) {
					die( wp_json_encode( [ 'error' => esc_html__( 'Please click again to login with Facebook and allow the application to use your email address', 'typer-pro' ) ] ) );
				}

				if ( empty( $name ) ) {
					die( wp_json_encode( [
						'error' => 'empty_name',
						esc_html__( 'We didn\'t find your name. Please complete your facebook account before proceeding.', 'typer-pro' )
					] ) );
				}

				$user_login = sanitize_title_with_dashes( sanitize_user( $display_name, true ) );

				if ( username_exists( $user_login ) ) {
					$user_login .= time();
				}

				$user_pass = wp_generate_password( 12, false );
				$userdata  = compact( 'user_login', 'user_email', 'user_pass', 'display_name', 'first_name', 'last_name' );
				$userdata  = apply_filters( 'svq_fb_register_data', $userdata );

				$user_ID = wp_insert_user( $userdata );
				if ( is_wp_error( $user_ID ) ) {
					die( wp_json_encode( [ 'error' => $user_ID->get_error_message() ] ) );
				}

				if ( class_exists( '\FUP\FupPlugin' ) ) {
					if ( isset( $_POST['category'] ) && $_POST['category'] ) {
						$categories = @json_decode( $_POST['category'] );
						if ( is_array( $categories ) ) {
							foreach ( $categories as $category ) {
								\FUP\FollowCategory::instance()->simpleAddFollow( $user_ID, $category );
							}
						}
					}
				}

				//send email with password
				wp_new_user_notification( $user_ID, wp_unslash( $user_pass ) );

				do_action( 'fb_register_action', $user_ID );
				do_action( 'user_register', $user_ID );

				update_user_meta( $user_ID, '_fbid', $id );
				$logintype = 'register';

				/* Registration logic redirect */
				if ( function_exists( 'bp_is_active' ) && svq_option( 'fb_register_redirect', 'default' ) == 'default' ) {
					$redirect_url = bp_core_get_user_domain( $user_ID ) . 'profile/edit/group/1/?fb=registered';
				} elseif ( svq_option( 'fb_register_redirect', 'default' ) == 'reload' ) {
					$redirect_type = 'reload';
					$redirect_url  = home_url();
				} elseif ( svq_option( 'fb_register_redirect', 'default' ) == 'custom' ) {
					$redirect_url = svq_option( 'fb_register_redirect_url', '' );
					if ( function_exists( 'bp_is_active' ) ) {
						$logged_in_link = bp_core_get_user_domain( $user_ID );
						$redirect_url   = str_replace( '##profile_link##', $logged_in_link, $redirect_url );
					}
				}

				if ( ! isset( $redirect_url ) || empty( $redirect_url ) ) {
					$redirect_type = 'reload';
					$redirect_url  = home_url();
				}

				$redirect = apply_filters( 'svq_fb_register_redirect', $redirect_url, $user_ID );
			} else {
				update_user_meta( $user_ID, '_fbid', $FB_userdata['id'] );
				$logintype = 'login';
			}
		} else {
			$logintype = 'login';
		}

		$user = get_user_by( 'id', $user_ID );

		if ( $logintype === 'login' ) {

			$redirect_to = home_url();
			if ( function_exists( 'bp_is_active' ) ) {
				$redirect_to = bp_core_get_user_domain( $user_ID );
			}

			/* Check the configured type of redirect */
			if ( svq_option( 'login_redirect' ) === 'reload' ) {
				$redirect_type = 'reload';
			}

			/**
			 * Filter the login redirect URL.
			 *
			 * @param string $redirect_to The redirect destination URL.
			 * @param string $requested_redirect_to The requested redirect destination URL passed as a parameter.
			 * @param \WP_User|\WP_Error $user WP_User object if login was successful, WP_Error object otherwise.
			 *
			 * @since 3.0.0
			 *
			 */

			$redirect = apply_filters( 'login_redirect', $redirect_to, '', $user );
		}

		if ( ! $redirect ) {
			$redirect = home_url( '/' );
		}

		wp_set_auth_cookie( $user_ID, false, false );
		/**
		 * Fires after the user has successfully logged in.
		 *
		 * @param string $user_login Username.
		 * @param \WP_User $user WP_User object of the logged-in user.
		 *
		 * @since 1.5.0
		 *
		 */
		do_action( 'wp_login', $user->user_login, $user );

		die( json_encode( [
			'loggedin'     => true,
			'type'         => $logintype,
			'url'          => $redirect,
			'redirectType' => $redirect_type,
			'message'      => esc_html__( 'Login successful, redirecting...', 'typer-pro' )
		] ) );
	}

	/**
	 * Adds fb register notice
	 */
	public function fb_register_message() {
		if ( isset( $_GET['fb'] ) && $_GET['fb'] === 'registered' ) {
			echo '<div class="clearfix"></div><div class="alert alert-success" id="message" data-alert>';
			echo esc_html__( 'Thank you for registering. Please make sure to complete your profile fields below.', 'typer-pro' );
			echo '</div>';
		}
	}

	/**
	 * Register register activity on BP
	 *
	 * @param $user_id
	 */
	public function fb_register_activity( $user_id ) {
		if ( ! function_exists( 'bp_activity_add' ) || ! function_exists( 'bp_core_get_userlink' ) ) {
			return;
		}

		$user_link = bp_core_get_userlink( $user_id );
		bp_activity_add( [
			'user_id'   => $user_id,
			'action'    => apply_filters( 'xprofile_fb_register_action', sprintf( esc_html__( '%s became a registered member', 'buddypress' ), $user_link ), $user_id ),
			'component' => 'xprofile',
			'type'      => 'new_member',
		] );
	}

	/**
	 * Outputs fb button
	 */
	public function the_fb_button() {
		echo $this->get_fb_button();
	}

	/**
	 * Returns fb button
	 *
	 * @param string $title
	 *
	 * @return string
	 */
	public function get_fb_button( $title = '' ) {
		if ( $title === '' ) {
			$title = esc_html__( 'Continue with Facebook', 'typer-pro' );
		}

		ob_start();

		?>
		<button type="button" class="svq-facebook-connect btn btn-sm btn-facebook">
			<i class="svq-icon icon-facebook icon--x18"></i> <span><?php echo $title; ?></span>
		</button>
		<?php

		return ob_get_clean();
	}

	/**
	 * Separator
	 */
	public function social_or() {
		echo ''; // no separator
	}

}

Component::instance();
