<?php

namespace SQ_Elements\GutenbergExtra\Notes;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class Component
 */
class Component {

	/**
	 * @var null
	 */
	public static $instance = null;

	public $notes_references = [];

	/**
	 * @return Component|null
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Notes constructor.
	 */
	public function __construct() {
		add_filter( 'the_post', [ $this, 'notes_reset_count' ] );
		add_filter( 'the_content', [ $this, 'notes_replace_with_shortcode' ] );
		add_action( 'wp_enqueue_scripts', [ $this, 'notes_enqueue_scripts' ] );
		add_action( 'enqueue_block_editor_assets', [ $this, 'notes_gutenberg_button' ] );

		if ( is_admin() ) {
			add_filter( 'init', [ $this, 'notes_add_mce_button' ] );
			add_action( 'admin_enqueue_scripts', [ $this, 'notes_add_mce_scripts' ] );
		}


		$this->notes_shortcodes();
	}

	public function notes_shortcodes() {
		add_shortcode( 'svq-note', [ $this, 'notes_render' ] );
	}

	public function notes_render( $atts, $content = "" ) {
		$additional_attributes = '';
		if ( isset( $atts['referencenumber'] ) ) {
			$display_number        = $atts['referencenumber'];
			$additional_attributes = 'refnum="' . $display_number . '"';
		} else if ( count( $this->notes_references ) === 0 ) {
			$display_number = 1;
		} else {
			$display_number = max( $this->notes_references ) + 1;
		}

		$content = do_shortcode( $content );

		$content = str_replace( array( '<p>', '</p>' ), array( '', '<br /><br />' ), $content );

		$content                  = '<sup class="svq-sidelink" data-svq-note="' . str_replace( '"', "\\\"", $display_number ) . '"><a href="javascript:void(0)" ' . $additional_attributes . '>' . $display_number . '</a></sup>' .
		                            '<span class="svq-sidenote will-animate" data-cssanimate="fadeIn" data-svq-note="' . str_replace( '"', "\\\"", $display_number ) . '">' . $content . '</span>';
		$this->notes_references[] = $display_number;

		return $content;
	}

	public function notes_replace_with_shortcode( $content ) {
		$content = str_replace( array( '<svq-note>', '</svq-note>' ), array( '[svq-note]', '[/svq-note]' ), $content );

		return $content;
	}

	public function notes_reset_count() {
		global $notes_count;
		$notes_count = 1;
	}

	public function notes_enqueue_scripts() {
		wp_enqueue_style( 'sq-notes', SQB_ASSETS_URL . 'css/notes/styles.css', [], TYPER_PRO_VERSION );
		wp_enqueue_script( 'sq-notes', SQB_ASSETS_URL . 'js/notes/sq-notes.js', [ 'jquery' ], TYPER_PRO_VERSION, true );
	}

	public function notes_add_mce_button() {
		if ( ! current_user_can( 'edit_posts' ) && ! current_user_can( 'edit_pages' ) ) {
			return;
		}
		if ( get_user_option( 'rich_editing' ) === 'true' ) {
			add_filter( 'mce_external_plugins', [ $this, 'notes_add_plugin' ] );
			add_filter( 'mce_buttons', [ $this, 'notes_register_button' ] );
		}
	}

	public function notes_register_button( $buttons ) {
		$buttons[] = 'sq_notes';

		return $buttons;
	}

	public function notes_add_plugin( $plugin_array ) {
		$plugin_array['sq_notes'] = SQB_ASSETS_URL . 'js/notes/sq-notes.mce-button.js';

		return $plugin_array;
	}

	public function notes_add_mce_scripts() {
		wp_enqueue_style( 'sq-notes', SQB_ASSETS_URL . 'css/notes/styles-mce-button.css', [], TYPER_PRO_VERSION );
	}

	public function notes_gutenberg_button() {
		wp_enqueue_script( 'sq_notes_block_editor_js',
			SQB_ASSETS_URL . 'js/notes/sq-notes.block-editor.js',
			[ 'wp-rich-text', 'wp-element', 'wp-editor' ],
			TYPER_PRO_VERSION
		);
		wp_enqueue_style( 'sq_notes_block_editor_css', SQB_ASSETS_URL . 'css/notes/styles-block-editor-button.css', [], TYPER_PRO_VERSION );
	}

}

Component::instance();
