var TPAutoloader = TPAutoloader || {};

(function ($) {

	// USE STRICT
	"use strict";

	TPAutoloader.vars = {
		nextUrl: ''
	};

	TPAutoloader.fn = {
		init: function () {
			TPAutoloader.fn.start();
			TPAutoloader.fn.watcher();
		},

		start: function () {
			$(window).scroll(function () {
				$('.svq-main-page').each(function (i) {
					var currentContent = $(this);
					var nextContent = currentContent.attr('data-next-url');
					var currentUrl = window.location.href;

					if (currentUrl.indexOf('#comments') > -1 || currentUrl.match(/#comment-*([0-9]+)/)) {
						return;
					}

					if (currentUrl.indexOf('#respond') > -1) {
						return;
					}

					if (!nextContent) {
						return;
					}

					var triggerBottom = currentContent.offset().top + currentContent.height();
					var windowHeight = $(window).scrollTop() + $(window).height();
					if (triggerBottom < windowHeight) {
						currentContent.removeAttr('data-next-url');
						TPAutoloader.vars.nextUrl = nextContent;
						$.ajax({
							method: 'POST',
							url: nextContent,
							success: function (response) {
								var content = $(response).find('.svq-site-content');

								$('.svq-body-section').append(content);

								$(window).trigger('svq-post-changed');
								$(window).trigger('resize');
							}
						});
					}
				});
			});
		},

		watcher: function () {
			$(window).scroll(function () {
				var permalink = '';
				var title = '';

				$('.svq-main-page').each(function (i) {
					var article = $(this);
					var panel = article.prev();

					var articleTop = article.offset().top - panel.height();
					var articleBottomEnd = articleTop + article.height();

					var windowTop = $(window).scrollTop();
					var windowBottomEnd = windowTop + $(window).height();

					if (articleBottomEnd > windowTop && articleTop < windowBottomEnd) {
						permalink = article.data('url');
						if (!article.data('title') && i === 0) {
							article.attr('data-title', $('head>title').text());
						}
						title = article.data('title');
					}
				}).promise().done(function () {
					var location = window.location.toString();
					if (permalink && permalink !== location) {
						window.history.pushState({url: permalink}, title, permalink);
						$('head>title').html(title);
					}
				});
			});
		},

		analyticsTrigger: function () {
			if (typeof _gaq === 'undefined' && typeof ga === 'undefined' && typeof __gaTracker === 'undefined') {
				return;
			}

			var post_url = TPAutoloader.vars.nextUrl.replace(/https?:\/\/[^\/]+/i, '');

			if (typeof _gaq !== 'undefined' && _gaq !== null) {
				_gaq.push(['_trackPageview', post_url]);
			}

			if (typeof ga !== 'undefined' && ga !== null) {
				ga('send', 'pageview', post_url);
			}

			if (typeof __gaTracker !== 'undefined' && __gaTracker !== null) {
				__gaTracker('send', 'pageview', post_url);
			}
		}
	};

	$(document).ready(TPAutoloader.fn.init);
	$(window).on('svq-post-changed', TPAutoloader.fn.analyticsTrigger);

})(jQuery);
