(function() {
	tinymce.PluginManager.add('sq_notes', function(editor, url) {
		editor.addButton('sq_notes', {
			title: 'Add a Note',
			icon: 'svq-note-admin-button',
			onclick: function() {
				editor.focus();
				var content = editor.selection.getContent();
				if (content.length > 0) {
					if (content.indexOf('[svq-note]') != -1 && content.indexOf('[/svq-note]') != -1) {
						editor.selection.setContent(content.replace(/\[svq-note\]/, '').replace(/\[\/svq-note\]/, ''));
					}
				} else {
					editor.windowManager.open({
						title: 'Insert Note',
						body: [
							{
								type: 'textbox',
								name: 'note',
								label: 'Note',
							}],
						onsubmit: function(e) {
							editor.insertContent('[svq-note]' + e.data.footnote + '[/svq-note]');
						},
					});
				}
			},
		});
	});
})();
