(function(wp) {
	var ModernFootnotesButton = function(props) {
		return wp.element.createElement(
			wp.editor.RichTextToolbarButton, {
				icon: wp.element.createElement('span', {'class': 'svq-note-admin-button'}),
				title: 'Add a Note',
				onClick: function() {
					props.onChange(wp.richText.toggleFormat(
						props.value,
						{type: 'sq-notes/note'},
					));
				},
				isActive: props.isActive,
			},
		);
	};
	wp.richText.registerFormatType(
		'sq-notes/note', {
			title: 'Add a Note',
			tagName: 'svq-note',
			className: null,
			edit: ModernFootnotesButton,
		},
	);
})(window.wp);
