<?php

namespace TyperPro\Customizer;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use TyperPro\Helper;

/**
 * Class PostListingOptions
 * @package TyperPro\Customizer
 */
class PostListingOptions {

	/**
	 * @var array
	 */
	private $sq = [];

	/**
	 * @var string
	 */
	private $panel = '';

	/**
	 * @param $name
	 *
	 * @return $this
	 */
	public function set_panel_name( $name ) {
		$this->panel = $name;

		return $this;
	}

	/**
	 * @param int $priority
	 *
	 * @return array
	 */
	public function get_section( $priority = 10 ) {
		return [
			'title'    => esc_html__( 'Posts Listing', 'typer-pro' ),
			'panel'    => $this->panel,
			'priority' => $priority
		];
	}

	/**
	 * @return string
	 */
	public function get_section_slug() {
		return 'svq_section_blog_listing';
	}

	/**
	 * @return array
	 */
	public function get_options() {
		$this->sq['blog_post_listing'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'select',
			'choices'     => [
				'list'     => esc_html__( 'Default List', 'typer-pro' ),
				'list-big' => esc_html__( 'Big List', 'typer-pro' ),
				'masonry'  => esc_html__( 'Masonry', 'typer-pro' ),
				'grid'     => esc_html__( 'Grid', 'typer-pro' )
			],
			'default'     => 'masonry',
			'title'       => esc_html__( 'Posts Lists Style', 'typer-pro' ),
			'description' => esc_html__( 'How to display posts in archive listings?', 'typer-pro' )
		];

		$this->sq['blog_post_listing_thumb_position'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'radio',
			'choices'         => Helper::instance()->get_thumbnail_position_options(),
			'default'         => 'right',
			'title'           => esc_html__( 'Image position', 'typer-pro' ),
			'description'     => esc_html__( 'Pick image position', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_post_listing',
					'value'   => 'list',
					'compare' => '='
				]
			]
		];

		$this->sq['blog_post_thumbnail'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-radio-image',
			'choices'         => Helper::instance()->get_thumbnail_size_options_masonry(),
			'default'         => 'normal',
			'title'           => esc_html__( 'Post image/gallery/video size', 'typer-pro' ),
			'description'     => esc_html__( 'How do you want your thumbs to be displayed?', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_post_listing',
					'value'   => 'masonry',
					'compare' => '='
				]
			]
		];

		$this->sq['blog_post_thumbnail_list_big'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-radio-image',
			'choices'         => Helper::instance()->get_thumbnail_size_options_list_big(),
			'default'         => 'normal',
			'title'           => esc_html__( 'Post image/gallery/video size', 'typer-pro' ),
			'description'     => esc_html__( 'How do you want your thumbs to be displayed?', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_post_listing',
					'value'   => 'list-big',
					'compare' => '='
				]
			]
		];

		$this->sq['blog_post_image_standard'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'switch',
			'choices'     => Helper::instance()->get_switch_options(),
			'default'     => '1',
			'title'       => esc_html__( 'Show standard post featured image in listings', 'typer-pro' ),
			'description' => esc_html__( 'You can choose to disable showing images for standard post format in post listings', 'typer-pro' )
		];

		$this->sq['blog_post_show_categories'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'switch',
			'choices' => Helper::instance()->get_switch_options(),
			'default' => '1',
			'title'   => esc_html__( 'Show category', 'typer-pro' )
		];

		$meta_items = [
			'avatar' => esc_html__( 'Show author avatar', 'typer-pro' ),
			'author' => esc_html__( 'Show author name', 'typer-pro' ),
			'date'   => esc_html__( 'Show posted on date', 'typer-pro' ),
		];

		$meta_items_defaults = [ 'avatar', 'author', 'date' ];

		if ( class_exists( '\FUP\FupPlugin' ) ) {
			$meta_items['bookmark'] = esc_html__( 'Show bookmark button', 'typer-pro' );
			$meta_items_defaults[]  = 'bookmark';
		}

		$this->sq['blog_post_meta_items'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'multicheck',
			'choices' => $meta_items,
			'default' => $meta_items_defaults,
			'title'   => esc_html__( 'Meta items', 'typer-pro' )
		];

		$this->sq['blog_post_masonry_options_separator'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-separator',
			'label'           => esc_html__( 'Masonry options', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_post_listing',
					'value'   => 'masonry',
					'compare' => '='
				]
			]
		];

		$this->sq['blog_masonry_span'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'switch',
			'choices'         => Helper::instance()->get_switch_options(),
			'default'         => '0',
			'title'           => esc_html__( 'Make 1st post big', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_post_listing',
					'value'   => 'masonry',
					'compare' => '='
				]
			]
		];

		$this->sq['blog_masonry_row_title'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'custom',
			'default'         => '<span class="customize-control-title">' .
			                     esc_html__( 'Number of posts per row.', 'typer-pro' ) . '</span>',
			'active_callback' => [
				[
					'setting' => 'blog_post_listing',
					'value'   => 'masonry',
					'compare' => '='
				]
			]
		];

		$this->sq['blog_masonry_small_items'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-select',
			'choices'         => [
				'12' => esc_html__( '1', 'typer-pro' ),
				'6'  => esc_html__( '2', 'typer-pro' )
			],
			'default'         => [
				'desktop' => '6',
				'tablet'  => '6',
				'mobile'  => '12',
			],
			'responsive'      => true,
			'column'          => '6',
			'title'           => esc_html__( 'Sidebar Layout', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_post_listing',
					'value'   => 'masonry',
					'compare' => '='
				]
			]
		];

		$this->sq['blog_masonry_wide_items'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-select',
			'choices'         => [
				'12' => esc_html__( '1', 'typer-pro' ),
				'6'  => esc_html__( '2', 'typer-pro' ),
				'4'  => esc_html__( '3', 'typer-pro' ),
				'3'  => esc_html__( '4', 'typer-pro' )
			],
			'default'         => [
				'desktop' => '4',
				'tablet'  => '6',
				'mobile'  => '12',
			],
			'responsive'      => true,
			'column'          => '6',
			'title'           => esc_html__( 'Full Layout', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_post_listing',
					'value'   => 'masonry',
					'compare' => '='
				]
			]
		];

		$this->sq['blog_masonry_notice'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'custom',
			'default'         => '<div style="padding: 10px; background-color: #333; color: #fff;">' .
			                     esc_html__( 'Note: The number of posts per row for Sidebar Layout will also apply for Wide Layout (without sidebar).', 'typer-pro' ) . '</div>',
			'active_callback' => [
				[
					'setting' => 'blog_post_listing',
					'value'   => 'masonry',
					'compare' => '='
				]
			]
		];

		$this->sq['blog_post_grid_options_separator'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-separator',
			'label'           => esc_html__( 'Grid options', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_post_listing',
					'value'   => 'grid',
					'compare' => '='
				]
			]
		];

		$this->sq['blog_grid_row_title'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'custom',
			'default'         => '<span class="customize-control-title">' .
			                     esc_html__( 'Number of posts per row.', 'typer-pro' ) . '</span>',
			'active_callback' => [
				[
					'setting' => 'blog_post_listing',
					'value'   => 'grid',
					'compare' => '='
				]
			]
		];

		$this->sq['blog_grid_small_items'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-select',
			'choices'         => [
				'12' => esc_html__( '1', 'typer-pro' ),
			],
			'default'         => [
				'desktop' => '12',
				'tablet'  => '12',
				'mobile'  => '12',
			],
			'responsive'      => true,
			'column'          => '6',
			'title'           => esc_html__( 'Sidebar Layout', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_post_listing',
					'value'   => 'grid',
					'compare' => '='
				]
			]
		];

		$this->sq['blog_grid_wide_items'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-select',
			'choices'         => [
				'12' => esc_html__( '1', 'typer-pro' ),
				'3'  => esc_html__( '2', 'typer-pro' )
			],
			'default'         => [
				'desktop' => '3',
				'tablet'  => '12',
				'mobile'  => '12',
			],
			'responsive'      => true,
			'column'          => '6',
			'title'           => esc_html__( 'Full Layout', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_post_listing',
					'value'   => 'grid',
					'compare' => '='
				]
			]
		];

		$this->sq['blog_grid_notice'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'custom',
			'default'         => '<div style="padding: 10px; background-color: #333; color: #fff;">' .
			                     esc_html__( 'Note: The number of posts per row for Sidebar Layout will also apply for Wide Layout (without sidebar).', 'typer-pro' ) . '</div>',
			'active_callback' => [
				[
					'setting' => 'blog_post_listing',
					'value'   => 'grid',
					'compare' => '='
				]
			]
		];

		$this->sq['blog_listing_fs_list_separator'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-separator',
			'label'   => esc_html__( 'Default List font settings', 'typer-pro' )
		];

		$this->sq['blog_post_listing_default_title_font_size'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'sq-control-input',
			'title'       => esc_html__( 'Title font size', 'typer-pro' ),
			'default'     => [
				'mobile'  => [ 'size' => '1.31', 'unit' => 'rem' ],
				'tablet'  => [ 'size' => '1.5', 'unit' => 'rem' ],
				'desktop' => [ 'size' => '1.75', 'unit' => 'rem' ],
			],
			'column'      => '6',
			'units'       => [ 'px', 'em', 'rem' ],
			'defaultUnit' => 'rem',
			'responsive'  => true,
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--fs-article-list-title-sm', '$', 'mobile' ],
				[ '--fs-article-list-title-md', '$', 'tablet' ],
				[ '--fs-article-list-title-lg', '$', 'desktop' ],
			],
		];

		$this->sq['blog_post_listing_default_title_line_clamp'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'number',
			'title'       => esc_html__( 'Title max lines', 'typer-pro' ),
			'description' => esc_html__( 'Truncates titles to a predefined number of lines. If you have long titles and want to display the entire title, use a high number like 999.', 'typer-pro' ),
			'default'     => 2,
			'choices'     => [
				'min'  => 1,
				'max'  => 999,
				'step' => 1,
			],
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--line-clamp-list-title' ],
			],
		];

		$this->sq['blog_post_listing_default_excerpt_font_size'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'sq-control-input',
			'title'       => esc_html__( 'Excerpt font size', 'typer-pro' ),
			'default'     => [
				'mobile'  => [ 'size' => '1', 'unit' => 'rem' ],
				'tablet'  => [ 'size' => '1', 'unit' => 'rem' ],
				'desktop' => [ 'size' => '1.15', 'unit' => 'rem' ],
			],
			'column'      => '6',
			'units'       => [ 'px', 'em', 'rem' ],
			'defaultUnit' => 'rem',
			'responsive'  => true,
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--fs-article-list-sm', '$', 'mobile' ],
				[ '--fs-article-list-md', '$', 'tablet' ],
				[ '--fs-article-list-lg', '$', 'desktop' ],
			],
		];

		$this->sq['blog_listing_fs_big_list_separator'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-separator',
			'label'   => esc_html__( 'Big List font settings', 'typer-pro' )
		];

		$this->sq['blog_post_listing_big_title_font_size'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'sq-control-input',
			'title'       => esc_html__( 'Title font size', 'typer-pro' ),
			'default'     => [
				'mobile'  => [ 'size' => '1.5', 'unit' => 'rem' ],
				'tablet'  => [ 'size' => '1.75', 'unit' => 'rem' ],
				'desktop' => [ 'size' => '2.25', 'unit' => 'rem' ],
			],
			'column'      => '6',
			'units'       => [ 'px', 'em', 'rem' ],
			'defaultUnit' => 'rem',
			'responsive'  => true,
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--fs-article-big-title-sm', '$', 'mobile' ],
				[ '--fs-article-big-title-md', '$', 'tablet' ],
				[ '--fs-article-big-title-lg', '$', 'desktop' ],
			],
		];

		$this->sq['blog_post_listing_big_title_line_clamp'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'number',
			'title'       => esc_html__( 'Title max lines', 'typer-pro' ),
			'description' => esc_html__( 'Truncates titles to a predefined number of lines. If you have long titles and want to display the entire title, use a high number like 999.', 'typer-pro' ),
			'default'     => 2,
			'choices'     => [
				'min'  => 1,
				'max'  => 999,
				'step' => 1,
			],
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--line-clamp-big-title' ],
			],
		];

		$this->sq['blog_post_listing_big_excerpt_font_size'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'sq-control-input',
			'title'       => esc_html__( 'Excerpt font size', 'typer-pro' ),
			'default'     => [
				'mobile'  => [ 'size' => '1', 'unit' => 'rem' ],
				'tablet'  => [ 'size' => '1', 'unit' => 'rem' ],
				'desktop' => [ 'size' => '1.25', 'unit' => 'rem' ],
			],
			'column'      => '6',
			'units'       => [ 'px', 'em', 'rem' ],
			'defaultUnit' => 'rem',
			'responsive'  => true,
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--fs-article-big-sm', '$', 'mobile' ],
				[ '--fs-article-big-md', '$', 'tablet' ],
				[ '--fs-article-big-lg', '$', 'desktop' ],
			],
		];

		$this->sq['blog_listing_fs_masonry_separator'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-separator',
			'label'   => esc_html__( 'Masonry/Grid font settings', 'typer-pro' )
		];

		$this->sq['blog_post_listing_masonry_title_font_size'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'sq-control-input',
			'title'       => esc_html__( 'Title font size', 'typer-pro' ),
			'default'     => [
				'mobile'  => [ 'size' => '1.2', 'unit' => 'rem' ],
				'tablet'  => [ 'size' => '1.5', 'unit' => 'rem' ],
				'desktop' => [ 'size' => '1.5', 'unit' => 'rem' ],
			],
			'column'      => '6',
			'units'       => [ 'px', 'em', 'rem' ],
			'defaultUnit' => 'rem',
			'responsive'  => true,
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--fs-article-card-title-sm', '$', 'mobile' ],
				[ '--fs-article-card-title-md', '$', 'tablet' ],
				[ '--fs-article-card-title-lg', '$', 'desktop' ],
			],
		];

		$this->sq['blog_post_listing_masonry_title_line_clamp'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'number',
			'title'       => esc_html__( 'Masonry Title max lines', 'typer-pro' ),
			'description' => esc_html__( 'Truncates titles to a predefined number of lines. If you have long titles and want to display the entire title, use a high number like 999.', 'typer-pro' ),
			'default'     => 2,
			'choices'     => [
				'min'  => 1,
				'max'  => 999,
				'step' => 1,
			],
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--line-clamp-card-title' ],
			],
		];

		$this->sq['blog_post_listing_grid_title_line_clamp'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'number',
			'title'       => esc_html__( 'Grid Title max lines', 'typer-pro' ),
			'description' => esc_html__( 'Truncates titles to a predefined number of lines. If you have long titles and want to display the entire title, use a high number like 999.', 'typer-pro' ),
			'default'     => 2,
			'choices'     => [
				'min'  => 1,
				'max'  => 999,
				'step' => 1,
			],
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--line-clamp-grid-title' ],
			],
		];

		$this->sq['blog_post_listing_masonry_excerpt_font_size'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'sq-control-input',
			'title'       => esc_html__( 'Excerpt font size', 'typer-pro' ),
			'default'     => [
				'mobile'  => [ 'size' => '1', 'unit' => 'rem' ],
				'tablet'  => [ 'size' => '1', 'unit' => 'rem' ],
				'desktop' => [ 'size' => '1.15', 'unit' => 'rem' ],
			],
			'column'      => '6',
			'units'       => [ 'px', 'em', 'rem' ],
			'defaultUnit' => 'rem',
			'responsive'  => true,
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--fs-article-list-card-sm', '$', 'mobile' ],
				[ '--fs-article-list-card-md', '$', 'tablet' ],
				[ '--fs-article-list-card-lg', '$', 'desktop' ],
			],
		];

		$this->sq['blog_post_listing_archive_separator'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-separator',
			'label'   => esc_html__( 'Archive Page Title', 'typer-pro' )
		];

		$this->sq['blog_post_listing_title_bg_color'] = [
			'section'   => $this->get_section_slug(),
			'type'      => 'color',
			'default'   => '#fefafa',
			'title'     => esc_html__( 'Title background color', 'typer-pro' ),
			'transport' => 'postMessage',
			'css_vars'  => [
				[ '--archive-color' ],
				[ '--archive-h', 'hex_to_hsl_h' ],
				[ '--archive-s', 'hex_to_hsl_s' ],
				[ '--archive-l', 'hex_to_hsl_l' ],
				[ '--archive-contrast-color', 'color_contrast' ],
			],
		];

		$this->sq['blog_post_listing_title_bg_image'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-background',
			'default' => [
				'image' => get_parent_theme_file_uri( 'assets/img/category-panel-bg.png' )
			],
			'title'   => esc_html__( 'Title background image', 'typer-pro' ),
			'exclude' => [ 'type', 'color', 'attachment' ],
			'output'  => [
				[
					'element' => 'body.archive .svq-panel:after',
				],
				[
					'element' => 'body.search .svq-panel:after',
				],
			],
		];

		return $this->sq;

	}

}
