<?php

namespace TyperPro\Customizer;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use TyperPro\Helper;

/**
 * Class PerformanceOptions
 * @package TyperPro\Customizer
 */
class PerformanceOptions {

	/**
	 * @var array
	 */
	private $sq = [];

	/**
	 * @var string
	 */
	private $panel = '';

	/**
	 * @param $name
	 *
	 * @return $this
	 */
	public function set_panel_name( $name ) {
		$this->panel = $name;

		return $this;
	}

	/**
	 * @param int $priority
	 *
	 * @return array
	 */
	public function get_section( $priority = 10 ) {
		return [
			'title'    => esc_html__( 'Performance', 'typer-pro' ),
			'panel'    => $this->panel,
			'priority' => $priority
		];
	}

	/**
	 * @return string
	 */
	public function get_section_slug() {
		return 'svq_section_performance';
	}

	/**
	 * @return array
	 */
	public function get_options() {

		$this->sq['css_preload'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'switch',
			'choices'     => Helper::instance()->get_switch_options(),
			'default'     => '1',
			'title'       => esc_html__( 'Preload theme Css files', 'typer-pro' ),
			'description' => wp_kses_data( sprintf( __( 'Tell the browser to prioritize theme css files. <a target="_blank" href="%s">Read more</a>', 'typer-pro' ), ' https://developers.google.com/web/updates/2016/03/link-rel-preload' ) ),
		];

		return $this->sq;

	}

}
