<?php

namespace TyperPro\Customizer;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use TyperPro\Helper;

/**
 * Class FeaturedContentOptions
 * @package TyperPro\Customizer
 */
class FeaturedContentOptions {

	/**
	 * @var array
	 */
	private $sq = [];

	/**
	 * @var string
	 */
	private $panel = '';

	/**
	 * @param $name
	 *
	 * @return $this
	 */
	public function set_panel_name( $name ) {
		$this->panel = $name;

		return $this;
	}

	/**
	 * @param int $priority
	 *
	 * @return array
	 */
	public function get_section( $priority = 10 ) {
		return [
			'title'    => esc_html__( 'Featured Content', 'typer-pro' ),
			'panel'    => $this->panel,
			'priority' => $priority
		];
	}

	/**
	 * @return string
	 */
	public function get_section_slug() {
		return 'svq_section_blog_featured_content';
	}

	/**
	 * @return array
	 */
	public function get_options() {

		$this->sq['blog_featured_content_status'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'switch',
			'choices'     => Helper::instance()->get_switch_options(),
			'default'     => '1',
			'title'       => esc_html__( 'Show Featured Content', 'typer-pro' ),
			'description' => wp_kses_post( sprintf(
				__( 'Will appear on your main blog page before all posts. Use the <a href="%1$s">"featured" tag</a> to feature your posts. You can change this to a tag of your choice.', 'typer-pro' ),
				admin_url( '/edit.php?tag=featured' ),
				admin_url( '/edit.php?show_sticky=1' )
			) )
		];

		$this->sq['blog_featured_content_title'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'text',
			'default'         => esc_html__( 'Featured on Typer', 'typer-pro' ),
			'title'           => esc_html__( 'Title', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				]
			]
		];

		$this->sq['blog_featured_content_tag'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'text',
			'default'         => 'featured',
			'title'           => esc_html__( 'Tag name', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				]
			]
		];

		$this->sq['blog_featured_sticky_status'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'switch',
			'choices'         => Helper::instance()->get_switch_options(),
			'default'         => '0',
			'title'           => esc_html__( 'Show Sticky Posts', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				]
			]
		];

		$this->sq['blog_featured_tag_display'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'switch',
			'choices'         => Helper::instance()->get_switch_options(),
			'default'         => '1',
			'title'           => esc_html__( 'Display tag on front end', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				]
			]
		];

		$this->sq['blog_featured_title_separator'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-separator',
			'label'           => esc_html__( 'Appearance', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				]
			],
		];

		$this->sq['blog_featured_type'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'select',
			'choices'         => [
				'style_1' => esc_html__( 'Style 1', 'typer-pro' ),
				'style_2' => esc_html__( 'Style 2', 'typer-pro' ),
			],
			'default'         => 'style_1',
			'title'           => esc_html__( 'Type', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				]
			],
		];

		$this->sq['blog_post_listing_section_title_font_size'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'sq-control-input',
			'title'       => esc_html__( 'Section title font size', 'typer-pro' ),
			'default'     => [
				'mobile'  => [ 'size' => '1.31', 'unit' => 'rem' ],
				'tablet'  => [ 'size' => '1.75', 'unit' => 'rem' ],
				'desktop' => [ 'size' => '2.13', 'unit' => 'rem' ],
			],
			'column'      => '6',
			'units'       => [ 'px', 'em', 'rem' ],
			'defaultUnit' => 'rem',
			'responsive'  => true,
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--fs-featured-section-title-sm', '$', 'mobile' ],
				[ '--fs-featured-section-title-md', '$', 'tablet' ],
				[ '--fs-featured-section-title-lg', '$', 'desktop' ],
			],
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				],
				[
					'setting'  => 'blog_featured_type',
					'operator' => '===',
					'value'    => 'style_1',
				]
			],
		];


		$this->sq['blog_featured_title_font_size'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-input',
			'title'           => esc_html__( 'Card title font size', 'typer-pro' ),
			'default'         => [
				'mobile'  => [ 'size' => '1.75', 'unit' => 'rem' ],
				'tablet'  => [ 'size' => '1.75', 'unit' => 'rem' ],
				'desktop' => [ 'size' => '1.75', 'unit' => 'rem' ],
			],
			'column'          => '6',
			'units'           => [ 'px', 'em', 'rem' ],
			'defaultUnit'     => 'rem',
			'responsive'      => true,
			'transport'       => 'postMessage',
			'css_vars'        => [
				[ '--fs-featured-art-list-title-sm', '$', 'mobile' ],
				[ '--fs-featured-art-list-title-md', '$', 'tablet' ],
				[ '--fs-featured-art-list-title-lg', '$', 'desktop' ],
			],
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				],
				[
					'setting'  => 'blog_featured_type',
					'operator' => '===',
					'value'    => 'style_1',
				]
			],
		];

		$this->sq['blog_featured_title_line_clamp'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'number',
			'title'       => esc_html__( 'Card title max lines', 'typer-pro' ),
			'description' => esc_html__( 'Truncates titles to a predefined number of lines. If you have long titles and want to display the entire title, use a high number like 999.', 'typer-pro' ),
			'default'     => 2,
			'choices'     => [
				'min'  => 1,
				'max'  => 999,
				'step' => 1,
			],
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--line-clamp-featured-list-title' ],
			],
		];


		$this->sq['blog_featured_content_bg_color'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'color',
			'default'         => '#fff3e0',
			'title'           => esc_html__( 'Background color', 'typer-pro' ),
			'transport'       => 'postMessage',
			'css_vars'        => [
				[ '--featured-color' ],
				[ '--featured-h', 'hex_to_hsl_h' ],
				[ '--featured-s', 'hex_to_hsl_s' ],
				[ '--featured-l', 'hex_to_hsl_l' ],
				[ '--featured-contrast-color', 'color_contrast' ],
			],
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				],
				[
					'setting'  => 'blog_featured_type',
					'operator' => '===',
					'value'    => 'style_1',
				]
			],
		];

		$this->sq['blog_featured_content_bg_image'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-background',
			'default'         => [
				'image'    => get_parent_theme_file_uri( 'assets/img/featured-bg.png' ),
				'position' => 'top',
				'size'     => 'cover'
			],
			'title'           => esc_html__( 'Background image', 'typer-pro' ),
			'exclude'         => [ 'type', 'color', 'attachment' ],
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				],
				[
					'setting'  => 'blog_featured_type',
					'operator' => '===',
					'value'    => 'style_1',
				]
			],
			'output'          => [
				[
					'element' => '.svq-media-slider.svq-media-slider--featured:after',
				]
			],
		];


		$this->sq['blog_featured_style_2_title_position'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-radio-image',
			'choices'         => Helper::instance()->get_featured_media_title_position_options(),
			'default'         => 'half',
			'title'           => esc_html__( 'Title position', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				],
				[
					'setting'  => 'blog_featured_type',
					'operator' => '===',
					'value'    => 'style_2',
				]
			],
		];

		$this->sq['blog_featured_style_2_title_size'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-radio-image',
			'choices'         => Helper::instance()->get_media_title_size_options(),
			'default'         => 'large',
			'title'           => esc_html__( 'Title size', 'typer-pro' ),
			'description'     => esc_html__( 'Choose the title size', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				],
				[
					'setting'  => 'blog_featured_type',
					'operator' => '===',
					'value'    => 'style_2',
				]
			],
		];

		$this->sq['blog_featured_style_2_title_over_alignment'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-radio-image',
			'choices'         => Helper::instance()->get_media_title_alignment_options(),
			'default'         => 'middle-center',
			'title'           => esc_html__( 'Title alignment', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				],
				[
					'setting'  => 'blog_featured_style_2_title_position',
					'operator' => '===',
					'value'    => 'title-over',
				],
				[
					'setting'  => 'blog_featured_type',
					'operator' => '===',
					'value'    => 'style_2',
				]
			],
		];

		$this->sq['blog_featured_style_2_media_catbread_type'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-radio-image',
			'choices'         => Helper::instance()->get_media_meta_options(),
			'default'         => 'category-breadcrumb',
			'title'           => esc_html__( 'Category and breadcrumbs', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				],
				[
					'setting'  => 'blog_featured_type',
					'operator' => '===',
					'value'    => 'style_2',
				]
			],
		];

		$this->sq['blog_featured_style_2_excerpt_show'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'switch',
			'choices'         => Helper::instance()->get_switch_options(),
			'default'         => '1',
			'title'           => esc_html__( 'Excerpt', 'typer-pro' ),
			'description'     => esc_html__( 'Show post excerpt', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				],
				[
					'setting'  => 'blog_featured_type',
					'operator' => '===',
					'value'    => 'style_2',
				]
			],
		];

		$this->sq['blog_featured_style_2_meta_show'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'switch',
			'choices'         => Helper::instance()->get_switch_options(),
			'default'         => '1',
			'title'           => esc_html__( 'Meta', 'typer-pro' ),
			'description'     => esc_html__( 'Show post meta', 'typer-pro' ),
			'active_callback' => [
				[
					'setting' => 'blog_featured_content_status',
					'value'   => true,
				],
				[
					'setting'  => 'blog_featured_type',
					'operator' => '===',
					'value'    => 'style_2',
				]
			],
		];

		return $this->sq;

	}

}
