<?php

namespace TyperPro\Customizer;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use TyperPro\Helper;

/**
 * Class CommentsOptions
 * @package TyperPro\Customizer
 */
class CommentsOptions {

	/**
	 * @var array
	 */
	private $sq = [];

	/**
	 * @var string
	 */
	private $panel = '';

	/**
	 * @param $name
	 *
	 * @return $this
	 */
	public function set_panel_name( $name ) {
		$this->panel = $name;

		return $this;
	}

	/**
	 * @param int $priority
	 *
	 * @return array
	 */
	public function get_section( $priority = 10 ) {
		return [
			'title'    => esc_html__( 'Comments', 'typer-pro' ),
			'panel'    => $this->panel,
			'priority' => $priority
		];
	}

	/**
	 * @return string
	 */
	public function get_section_slug() {
		return 'svq_section_blog_comments';
	}

	/**
	 * @return array
	 */
	public function get_options() {

		$this->sq['blog_comments_modal'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'switch',
			'choices'     => Helper::instance()->get_switch_options(),
			'default'     => '0',
			'title'       => esc_html__( 'Show in modal', 'typer-pro' ),
			'description' => esc_html__( 'Open Comments list and New Comment Form in modal', 'typer-pro' ),
		];

		return $this->sq;

	}

}
