<?php

namespace TyperPro\Customizer;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use TyperPro\Helper;

/**
 * Class BlogOptions
 * @package TyperPro\Customizer
 */
class BlogOptions {

	/**
	 * @var array
	 */
	private $sq = [];

	/**
	 * @var string
	 */
	private $panel = '';

	/**
	 * @param $name
	 *
	 * @return $this
	 */
	public function set_panel_name( $name ) {
		$this->panel = $name;

		return $this;
	}

	/**
	 * @var string
	 */
	public $type = 'section';

	/**
	 * @param int $priority
	 *
	 * @return array
	 */
	public function get_section( $priority = 10 ) {
		return [
			'title'    => esc_html__( 'Blog Single Post', 'typer-pro' ),
			'panel'    => $this->panel,
			'priority' => $priority
		];
	}

	/**
	 * @return string
	 */
	public function get_section_slug() {
		return 'svq_section_blog';
	}

	/**
	 * @return array
	 */
	public function get_options() {
		$panels = Helper::instance()->get_post_formats();

		$settings = [];

		foreach ( $panels as $key => $blog_panel ) {

			$this->sq['sec'][ 'svq_section_blog_' . $blog_panel ] = [
				'title'    => esc_html__( ucfirst( $blog_panel ), 'typer-pro' ),
				'section'  => $this->get_section_slug(),
				'priority' => $key + 10
			];

			$settings['blog_intro_text'] = [
				'section' => $this->get_section_slug(),
				'type'    => 'custom',
				'default' => '<div style="padding: 10px; background-color: #333; color: #fff;">' .
				             esc_html__( 'Note: From above sections you can override Single Post general settings by post format', 'typer-pro' ) .
				             '</div>'
			];

			if ( $blog_panel !== 'general' ) {
				$settings[ 'media_settings_overwrite_' . $blog_panel ] = [
					'section'     => 'svq_section_blog_' . $blog_panel,
					'type'        => 'switch',
					'choices'     => Helper::instance()->get_switch_options(),
					'default'     => '0',
					'title'       => esc_html__( 'Override General settings', 'typer-pro' ),
					'description' => esc_html__( 'Here you can overwrite the settings for this post format. By default, all of your settings for this post format are inherited from the general settings. Please be aware that some of the settings are only available in the General tab and will apply for all the posts formats.', 'typer-pro' ),
				];
			}

			$settings[ 'media_separator_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'sq-control-separator',
				'label'           => esc_html__( 'Media Panel', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			$settings[ 'media_fullscreen_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'sq-control-fullscreen-slider',
				'default'         => '1',
				'title'           => esc_html__( 'Full height', 'typer-pro' ),
				'description'     => esc_html__( 'When should it be full height? (UP TO)', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			if ( $blog_panel === 'general' ) {
				$settings[ 'media_max_height_' . $blog_panel ] = [
					'section'     => 'svq_section_blog_' . $blog_panel,
					'type'        => 'sq-control-input-slider',
					'choices'     => [
						'min'  => 500,
						'max'  => 900,
						'step' => 10,
					],
					'default'     => 800,
					'transport'   => 'postMessage',
					'css_vars'    => [
						[ '--media-max-height' ],
					],
					'title'       => esc_html__( 'Max height', 'typer-pro' ),
					'description' => esc_html__( 'Slide to set the height', 'typer-pro' )
				];
			}

			$settings[ 'media_content_color_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'sq-control-radio-image',
				'choices'         => Helper::instance()->get_title_color_options(),
				'default'         => 'dark',
				'title'           => esc_html__( 'Text color', 'typer-pro' ),
				'description'     => esc_html__( 'Choose the color for your panel content.', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			$settings[ 'media_panel_fade_scroll_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'switch',
				'choices'         => Helper::instance()->get_switch_options(),
				'default'         => '1',
				'title'           => esc_html__( 'Text fade on scroll', 'typer-pro' ),
				'description'     => esc_html__( 'Panel content will fade out when scrolling down (only when it has featured image/video/gallery)', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel ) && get_theme_mod( 'media_title_position_' . $blog_panel ) !== 'half';
				}
			];

			if ( $blog_panel === 'general' ) {
				$settings[ 'media_separator_1_' . $blog_panel ] = [
					'section' => 'svq_section_blog_' . $blog_panel,
					'type'    => 'sq-control-separator',
					'label'   => esc_html__( 'Top Reading Progress Bar', 'typer-pro' )
				];

				$settings[ 'progressive_bar_' . $blog_panel ] = [
					'section'     => 'svq_section_blog_' . $blog_panel,
					'type'        => 'switch',
					'choices'     => Helper::instance()->get_switch_options(),
					'default'     => '1',
					'title'       => esc_html__( 'Show', 'typer-pro' ),
					'description' => esc_html__( 'Show reading progress bar on top of page in single post only', 'typer-pro' )
				];
			}

			$settings[ 'media_separator_2_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'sq-control-separator',
				'label'           => esc_html__( 'Categories and Breadcrumbs', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			$settings[ 'media_catbread_type_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'sq-control-radio-image',
				'choices'         => Helper::instance()->get_media_meta_options(),
				'default'         => 'category-breadcrumb',
				'title'           => esc_html__( 'Style', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			$settings[ 'media_catbread_animation_type_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'select',
				'choices'         => Helper::instance()->get_fade_options(),
				'default'         => 'fadeInDown',
				'title'           => esc_html__( 'Animation', 'typer-pro' ),
				'description'     => esc_html__( 'Choose your entry animation type (only when featured content)', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel ) && get_theme_mod( 'media_catbread_type_' . $blog_panel ) !== 'none';
				}
			];

			$settings[ 'media_separator_3_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'sq-control-separator',
				'label'           => esc_html__( 'Title', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			$settings[ 'media_title_position_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'sq-control-radio-image',
				'choices'         => Helper::instance()->get_media_title_position_options(),
				'default'         => 'title-above',
				'title'           => esc_html__( 'Position', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			$settings[ 'media_title_over_alignment_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'sq-control-radio-image',
				'choices'         => Helper::instance()->get_media_title_alignment_options(),
				'default'         => 'default',
				'title'           => esc_html__( 'Alignment', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel ) && get_theme_mod( 'media_title_position_' . $blog_panel ) === 'title-over';
				}
			];

			$settings[ 'media_title_left_alignment_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'sq-control-radio-image',
				'choices'         => Helper::instance()->get_media_title_alignment_options(),
				'default'         => 'default',
				'title'           => esc_html__( 'Alignment', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel ) && get_theme_mod( 'media_title_position_' . $blog_panel ) === 'half';
				}
			];

			$settings[ 'media_title_above_below_alignment_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'sq-control-radio-image',
				'choices'         => Helper::instance()->get_media_title_alignment_options( true ),
				'default'         => 'default',
				'title'           => esc_html__( 'Alignment', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel ) &&
					       ( get_theme_mod( 'media_title_position_' . $blog_panel ) === 'title-above' ||
					         get_theme_mod( 'media_title_position_' . $blog_panel ) === 'title-below' );
				}
			];

			$settings[ 'media_title_size_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'sq-control-radio-image',
				'choices'         => Helper::instance()->get_media_title_size_options(),
				'default'         => 'default',
				'title'           => esc_html__( 'Size', 'typer-pro' ),
				'description'     => esc_html__( 'Choose the title size', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			$settings[ 'media_title_animation_type_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'select',
				'choices'         => Helper::instance()->get_fade_options(),
				'default'         => 'fadeIn',
				'title'           => esc_html__( 'Animation', 'typer-pro' ),
				'description'     => esc_html__( 'Choose your entry animation type (only when featured content)', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			if ( in_array( $blog_panel, [ 'image', 'general', 'standard' ] ) ) {
				$settings[ 'media_separator_4_' . $blog_panel ] = [
					'section'         => 'svq_section_blog_' . $blog_panel,
					'type'            => 'sq-control-separator',
					'label'           => esc_html__( 'Image', 'typer-pro' ),
					'active_callback' => function () use ( $blog_panel ) {
						return $this->show_field( $blog_panel );
					}
				];

				if ( in_array( $blog_panel, [ 'general' ] ) ) {
					$settings[ 'media_image_enabled_' . $blog_panel ] = [
						'section'         => 'svq_section_blog_' . $blog_panel,
						'type'            => 'switch',
						'choices'         => Helper::instance()->get_switch_options(),
						'default'         => '1',
						'title'           => esc_html__( 'Enable featured image for Standard Format', 'typer-pro' ),
						'description'     => esc_html__( 'Choose either to show or not the featured image for standard post format.', 'typer-pro' ),
						'active_callback' => function () use ( $blog_panel ) {
							return $this->show_field( $blog_panel );
						}
					];
				}

				$settings[ 'media_image_width_' . $blog_panel ] = [
					'section'         => 'svq_section_blog_' . $blog_panel,
					'type'            => 'sq-control-radio-image',
					'choices'         => Helper::instance()->get_media_width_options(),
					'default'         => 'wide',
					'title'           => esc_html__( 'Width', 'typer-pro' ),
					'description'     => esc_html__( 'Cover image width', 'typer-pro' ),
					'active_callback' => function () use ( $blog_panel ) {
						return $this->show_field( $blog_panel ) && get_theme_mod( 'media_title_position_' . $blog_panel ) !== 'half';
					}
				];

				$settings[ 'media_image_overlay_' . $blog_panel ] = [
					'section'         => 'svq_section_blog_' . $blog_panel,
					'type'            => 'select',
					'choices'         => Helper::instance()->get_color_options(),
					'default'         => 'none',
					'title'           => esc_html__( 'Color overlay', 'typer-pro' ),
					'description'     => esc_html__( 'Pick the overlay', 'typer-pro' ),
					'active_callback' => function () use ( $blog_panel ) {
						return $this->show_field( $blog_panel );
					}
				];

				$settings[ 'media_image_overlay_show_' . $blog_panel ] = [
					'section'         => 'svq_section_blog_' . $blog_panel,
					'type'            => 'sq-control-radio-image',
					'choices'         => Helper::instance()->get_color_overlay_options(),
					'default'         => 'both',
					'title'           => esc_html__( 'Show overlay on', 'typer-pro' ),
					'description'     => esc_html__( 'Where to show the overlay?', 'typer-pro' ),
					'active_callback' => function () use ( $blog_panel ) {
						$overlay = get_theme_mod( 'media_image_overlay_' . $blog_panel );

						return $this->show_field( $blog_panel ) && $overlay !== 'none';
					}
				];

				$settings[ 'media_image_background_type_' . $blog_panel ] = [
					'section'         => 'svq_section_blog_' . $blog_panel,
					'type'            => 'sq-control-radio-image',
					'choices'         => Helper::instance()->get_media_background_type_options(),
					'default'         => 'cover',
					'title'           => esc_html__( 'Image display type', 'typer-pro' ),
					'description'     => esc_html__( 'Choose if your image should fit the container or not', 'typer-pro' ),
					'active_callback' => function () use ( $blog_panel ) {
						return $this->show_field( $blog_panel );
					}
				];
			}

			if ( in_array( $blog_panel, [ 'general', 'video' ] ) ) {
				$settings[ 'media_separator_5_' . $blog_panel ] = [
					'section'         => 'svq_section_blog_' . $blog_panel,
					'type'            => 'sq-control-separator',
					'label'           => esc_html__( 'Video', 'typer-pro' ),
					'active_callback' => function () use ( $blog_panel ) {
						return $this->show_field( $blog_panel );
					}
				];

				$settings[ 'media_video_width_' . $blog_panel ] = [
					'section'         => 'svq_section_blog_' . $blog_panel,
					'type'            => 'sq-control-radio-image',
					'choices'         => Helper::instance()->get_media_width_options(),
					'default'         => 'wide',
					'title'           => esc_html__( 'Width', 'typer-pro' ),
					'description'     => esc_html__( 'Choose your video width', 'typer-pro' ),
					'active_callback' => function () use ( $blog_panel ) {
						return $this->show_field( $blog_panel ) && get_theme_mod( 'media_title_position_' . $blog_panel ) !== 'half';
					}
				];

				$settings[ 'media_video_overlay_' . $blog_panel ] = [
					'section'         => 'svq_section_blog_' . $blog_panel,
					'type'            => 'select',
					'choices'         => Helper::instance()->get_color_options(),
					'default'         => 'none',
					'title'           => esc_html__( 'Color overlay', 'typer-pro' ),
					'description'     => esc_html__( 'Pick the overlay color', 'typer-pro' ),
					'active_callback' => function () use ( $blog_panel ) {
						return $this->show_field( $blog_panel );
					}
				];

				$settings[ 'media_video_overlay_show_' . $blog_panel ] = [
					'section'         => 'svq_section_blog_' . $blog_panel,
					'type'            => 'sq-control-radio-image',
					'choices'         => Helper::instance()->get_color_overlay_options(),
					'default'         => 'both',
					'title'           => esc_html__( 'Show overlay on', 'typer-pro' ),
					'description'     => esc_html__( 'Where to show the overlay?', 'typer-pro' ),
					'active_callback' => function () use ( $blog_panel ) {
						$overlay = get_theme_mod( 'media_video_overlay_' . $blog_panel );

						return $this->show_field( $blog_panel ) && $overlay !== 'none';
					}
				];
			}

			if ( in_array( $blog_panel, [ 'general', 'gallery' ] ) ) {
				$settings[ 'media_separator_6_' . $blog_panel ] = [
					'section'         => 'svq_section_blog_' . $blog_panel,
					'type'            => 'sq-control-separator',
					'label'           => esc_html__( 'Gallery', 'typer-pro' ),
					'active_callback' => function () use ( $blog_panel ) {
						return $this->show_field( $blog_panel );
					}
				];

				$settings[ 'media_gallery_width_' . $blog_panel ] = [
					'section'         => 'svq_section_blog_' . $blog_panel,
					'type'            => 'sq-control-radio-image',
					'choices'         => Helper::instance()->get_media_width_options(),
					'default'         => 'full-width',
					'title'           => esc_html__( 'Width', 'typer-pro' ),
					'description'     => esc_html__( 'Gallery slider width', 'typer-pro' ),
					'active_callback' => function () use ( $blog_panel ) {
						return $this->show_field( $blog_panel ) && get_theme_mod( 'media_title_position_' . $blog_panel ) !== 'half';
					}
				];

				$settings[ 'media_gallery_item_width_' . $blog_panel ] = [
					'section'         => 'svq_section_blog_' . $blog_panel,
					'type'            => 'sq-control-radio-image',
					'choices'         => Helper::instance()->get_media_gallery_item_width_options(),
					'default'         => 'portrait',
					'title'           => esc_html__( 'Images width', 'typer-pro' ),
					'description'     => esc_html__( 'Choose the gallery images width', 'typer-pro' ),
					'active_callback' => function () use ( $blog_panel ) {
						return $this->show_field( $blog_panel );
					}
				];

				$settings[ 'media_gallery_overlay_' . $blog_panel ] = [
					'section'         => 'svq_section_blog_' . $blog_panel,
					'type'            => 'select',
					'choices'         => Helper::instance()->get_color_options(),
					'default'         => 'bottom',
					'title'           => esc_html__( 'Color overlay', 'typer-pro' ),
					'description'     => esc_html__( 'Pick the overlay color', 'typer-pro' ),
					'active_callback' => function () use ( $blog_panel ) {
						return $this->show_field( $blog_panel );
					}
				];

				$settings[ 'media_gallery_overlay_show_' . $blog_panel ] = [
					'section'         => 'svq_section_blog_' . $blog_panel,
					'type'            => 'sq-control-radio-image',
					'choices'         => Helper::instance()->get_color_overlay_options(),
					'default'         => 'single',
					'title'           => esc_html__( 'Show overlay on', 'typer-pro' ),
					'description'     => esc_html__( 'Where to show the overlay?', 'typer-pro' ),
					'active_callback' => function () use ( $blog_panel ) {
						return $this->show_field( $blog_panel ) && get_theme_mod( 'media_gallery_overlay_' . $blog_panel ) !== 'none';
					}
				];
			}

			$settings[ 'media_separator_7_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'sq-control-separator',
				'label'           => esc_html__( 'Meta', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			$settings[ 'media_meta_show_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'switch',
				'choices'         => Helper::instance()->get_switch_options(),
				'default'         => '1',
				'title'           => esc_html__( 'Show', 'typer-pro' ),
				'description'     => esc_html__( 'Show post meta', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			$meta_items          = Helper::instance()->get_media_meta_items_options();
			$meta_items_defaults = [ 'avatar', 'author', 'date', 'reading' ];

			if ( class_exists( '\FUP\FupPlugin' ) ) {
				$meta_items['bookmark'] = esc_html__( 'Show bookmark button', 'typer-pro' );
				$meta_items_defaults[]  = 'bookmark';
			}

			$settings[ 'media_meta_items_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'multicheck',
				'choices'         => $meta_items,
				'default'         => $meta_items_defaults,
				'title'           => esc_html__( 'Items', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel ) && get_theme_mod( 'media_meta_show_' . $blog_panel );
				}
			];

			$settings[ 'media_meta_animation_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'select',
				'choices'         => Helper::instance()->get_fade_options(),
				'default'         => 'fadeInUp',
				'title'           => esc_html__( 'Animation', 'typer-pro' ),
				'description'     => esc_html__( 'Choose your entry animation type (only when featured media)', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel ) && get_theme_mod( 'media_meta_show_' . $blog_panel );
				}
			];

			$settings[ 'media_separator_8_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'sq-control-separator',
				'label'           => esc_html__( 'Parallax Shapes', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			$settings[ 'media_shapes_show_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'switch',
				'choices'         => Helper::instance()->get_switch_options(),
				'default'         => '0',
				'title'           => esc_html__( 'Show', 'typer-pro' ),
				'description'     => esc_html__( 'Show parallax shapes or not', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			$settings[ 'media_separator_9_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'sq-control-separator',
				'label'           => esc_html__( 'Social box', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			$settings[ 'blog_show_social_box_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'switch',
				'choices'         => Helper::instance()->get_switch_options(),
				'default'         => '1',
				'title'           => esc_html__( 'Show social box', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel );
				}
			];

			$settings[ 'blog_force_social_box_top_' . $blog_panel ] = [
				'section'         => 'svq_section_blog_' . $blog_panel,
				'type'            => 'switch',
				'choices'         => Helper::instance()->get_switch_options(),
				'default'         => '0',
				'title'           => esc_html__( 'Show on top when no sidebar', 'typer-pro' ),
				'active_callback' => function () use ( $blog_panel ) {
					return $this->show_field( $blog_panel ) && get_theme_mod( 'blog_show_social_box_' . $blog_panel );
				}
			];
		}

		$this->sq['set'] = $settings;

		return $this->sq;

	}

	/**
	 * @param $panel
	 *
	 * @return bool
	 */
	private function show_field( $panel ) {
		return $panel === 'general' || get_theme_mod( 'media_settings_overwrite_' . $panel );
	}
}
