<?php

namespace TyperPro\Carbon;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use TyperPro\Helper;
use \Carbon_Fields\Container as Container;
use \Carbon_Fields\Field as Field;

/**
 * Class PostOptions
 * @package TyperPro
 */
class PostOptions {

	/**
	 * @var null
	 */
	public static $instance = null;

	/**
	 * @return PostOptions|null
	 */
	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function __construct() {
		add_action( 'carbon_fields_register_fields', [ $this, 'register_gutenberg_carbon' ] );
		add_action( 'carbon_fields_register_fields', [ $this, 'register_post_fields' ] );
	}

	/**
	 * Register meta boxes
	 */
	public function register_gutenberg_carbon() {
		if ( class_exists( '\Elementor\Plugin' ) && is_callable( '\Elementor\Plugin', 'instance' ) && \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			return;
		}

		if ( class_exists( 'Carbon_Fields\Container' ) && class_exists( 'Carbon_Fields\Field' ) ) {
			$post_formats  = Helper::instance()->get_post_formats();
			$color_options = Helper::instance()->get_color_options();
			$fade_options  = Helper::instance()->get_fade_options();
			$tabs          = Helper::instance()->get_carbon_tabs();

			foreach ( $post_formats as $format ) {
				if ( $format === 'general' ) {
					continue;
				}

				$container = Container::make( 'post_meta', 'Settings' )
				                      ->where( 'post_type', '=', 'post' )
				                      ->where( 'post_format', '=', $format );

				$fields = [];

				$fields['media-panel'] = [];

				$fields['media-panel'][] = Field::make( 'checkbox', 'media_panel_overwrite_individual', esc_html__( 'Overwrite Panel Customizer settings', 'typer-pro' ) );

				$fields['media-panel'][] = Field::make( 'select', 'media_fullscreen_individual', esc_html__( 'Full height', 'typer-pro' ) )
				                                ->set_help_text( esc_html__( 'When should it be full height? (UP TO)', 'typer-pro' ) )
				                                ->set_options( Helper::instance()->get_carbon_resolution_options() )
				                                ->set_default_value( '1' )
				                                ->set_conditional_logic( [
					                                [
						                                'field' => 'media_panel_overwrite_individual',
						                                'value' => true
					                                ]
				                                ] );

				$fields['media-panel'][] = Field::make( 'radio_image', 'media_content_color_individual', esc_html__( 'Text color', 'typer-pro' ) )
				                                ->set_help_text( esc_html__( 'Choose the color for your panel content.', 'typer-pro' ) )
				                                ->set_options( Helper::instance()->get_carbon_dark_light_options() )
				                                ->set_default_value( 'dark' )
				                                ->set_classes( 'no-flex' )
				                                ->set_conditional_logic( [
					                                [
						                                'field' => 'media_panel_overwrite_individual',
						                                'value' => true
					                                ]
				                                ] );

				$fields['media-panel'][] = Field::make( 'checkbox', 'media_panel_fade_scroll_individual', esc_html__( 'Text fade on scroll', 'typer-pro' ) )
				                                ->set_help_text( esc_html__( 'Panel content will fade out when scrolling down (only when it has featured image/video/gallery)', 'typer-pro' ) )
				                                ->set_default_value( 'yes' )
				                                ->set_conditional_logic( [
					                                [
						                                'field' => 'media_panel_overwrite_individual',
						                                'value' => true
					                                ],
					                                [
						                                'field'   => 'media_title_position_individual',
						                                'value'   => 'half',
						                                'compare' => '!='
					                                ]
				                                ] );

				if ( $format === 'image' || $format === 'standard' ) {
					$fields['image'] = [];

					$fields['image'][] = Field::make( 'checkbox', 'media_image_overwrite_individual', esc_html__( 'Overwrite Image Customizer settings', 'typer-pro' ) );

					$fields['image'][] = Field::make( 'radio_image', 'media_image_width_individual', esc_html__( 'Width', 'typer-pro' ) )
					                          ->set_help_text( esc_html__( 'Cover image width', 'typer-pro' ) )
					                          ->set_options( Helper::instance()->get_carbon_image_width_options() )
					                          ->set_default_value( 'full-width' )
					                          ->set_classes( 'no-flex' )
					                          ->set_conditional_logic( [
						                          [
							                          'field' => 'media_image_overwrite_individual',
							                          'value' => true
						                          ],
						                          [
							                          'field'   => 'media_title_position_individual',
							                          'value'   => 'half',
							                          'compare' => '!='
						                          ]
					                          ] );

					$fields['image'][] = Field::make( 'select', 'media_image_overlay_individual', esc_html__( 'Color overlay', 'typer-pro' ) )
					                          ->set_options( $color_options )
					                          ->set_default_value( 'none' )
					                          ->set_conditional_logic( [
						                          [
							                          'field' => 'media_image_overwrite_individual',
							                          'value' => true
						                          ]
					                          ] );

					$fields['image'][] = Field::make( 'radio_image', 'media_image_overlay_show_individual', esc_html__( 'Show overlay on', 'typer-pro' ) )
					                          ->set_options( Helper::instance()->get_carbon_overlay_show_options() )
					                          ->set_default_value( 'both' )
					                          ->set_classes( 'no-flex' )
					                          ->set_conditional_logic( [
						                          [
							                          'field' => 'media_image_overwrite_individual',
							                          'value' => true
						                          ],
						                          [
							                          'field'   => 'media_image_overlay_individual',
							                          'value'   => 'none',
							                          'compare' => '!='
						                          ]
					                          ] );

					$fields['image'][] = Field::make( 'radio_image', 'media_image_background_type_individual', esc_html__( 'Image display type', 'typer-pro' ) )
					                          ->set_help_text( esc_html__( 'Choose if your image should fit the container or not', 'typer-pro' ) )
					                          ->set_options( Helper::instance()->get_carbon_image_display_options() )
					                          ->set_default_value( 'cover' )
					                          ->set_classes( 'no-flex' )
					                          ->set_conditional_logic( [
						                          [
							                          'field' => 'media_image_overwrite_individual',
							                          'value' => true
						                          ]
					                          ] );
				}

				if ( $format === 'video' ) {
					$fields['video'] = [];

					$fields['video'][] = Field::make( 'checkbox', 'media_video_overwrite_individual', esc_html__( 'Overwrite Video Customizer settings', 'typer-pro' ) );

					$fields['video'][] = Field::make( 'radio_image', 'media_video_width_individual', esc_html__( 'Width', 'typer-pro' ) )
					                          ->set_help_text( esc_html__( 'Choose your video width', 'typer-pro' ) )
					                          ->set_options( Helper::instance()->get_carbon_image_width_options() )
					                          ->set_default_value( 'wide' )
					                          ->set_classes( 'no-flex' )
					                          ->set_conditional_logic( [
						                          [
							                          'field' => 'media_video_overwrite_individual',
							                          'value' => true
						                          ],
						                          [
							                          'field'   => 'media_title_position_individual',
							                          'value'   => 'half',
							                          'compare' => '!='
						                          ]
					                          ] );

					$fields['video'][] = Field::make( 'select', 'media_video_overlay_individual', esc_html__( 'Color overlay', 'typer-pro' ) )
					                          ->set_options( $color_options )
					                          ->set_default_value( 'none' )
					                          ->set_conditional_logic( [
						                          [
							                          'field' => 'media_video_overwrite_individual',
							                          'value' => true
						                          ]
					                          ] );

					$fields['video'][] = Field::make( 'radio_image', 'media_video_overlay_show_individual', esc_html__( 'Show overlay on', 'typer-pro' ) )
					                          ->set_options( Helper::instance()->get_carbon_overlay_show_options() )
					                          ->set_default_value( 'both' )
					                          ->set_classes( 'no-flex' )
					                          ->set_conditional_logic( [
						                          [
							                          'field' => 'media_video_overwrite_individual',
							                          'value' => true
						                          ],
						                          [
							                          'field'   => 'media_video_overlay_individual',
							                          'value'   => 'none',
							                          'compare' => '!='
						                          ]
					                          ] );
				}

				if ( $format === 'gallery' ) {
					$fields['gallery'] = [];

					$fields['gallery'][] = Field::make( 'checkbox', 'media_gallery_overwrite_individual', esc_html__( 'Overwrite Gallery Customizer settings', 'typer-pro' ) );

					$fields['gallery'][] = Field::make( 'radio_image', 'media_gallery_width_individual', esc_html__( 'Width', 'typer-pro' ) )
					                            ->set_help_text( esc_html__( 'Choose your gallery width', 'typer-pro' ) )
					                            ->set_options( Helper::instance()->get_carbon_image_width_options() )
					                            ->set_default_value( 'wide' )
					                            ->set_classes( 'no-flex' )
					                            ->set_conditional_logic( [
						                            [
							                            'field' => 'media_gallery_overwrite_individual',
							                            'value' => true
						                            ],
						                            [
							                            'field'   => 'media_title_position_individual',
							                            'value'   => 'half',
							                            'compare' => '!='
						                            ]
					                            ] );

					$fields['gallery'][] = Field::make( 'radio_image', 'media_gallery_item_width_individual', esc_html__( 'Images width', 'typer-pro' ) )
					                            ->set_help_text( esc_html__( 'Choose the gallery images width', 'typer-pro' ) )
					                            ->set_options( Helper::instance()->get_carbon_gallery_display_options() )
					                            ->set_default_value( 'portrait' )
					                            ->set_classes( 'no-flex' )
					                            ->set_conditional_logic( [
						                            [
							                            'field' => 'media_gallery_overwrite_individual',
							                            'value' => true
						                            ]
					                            ] );

					$fields['gallery'][] = Field::make( 'select', 'media_gallery_overlay_individual', esc_html__( 'Color overlay', 'typer-pro' ) )
					                            ->set_options( $color_options )
					                            ->set_default_value( 'none' )
					                            ->set_conditional_logic( [
						                            [
							                            'field' => 'media_gallery_overwrite_individual',
							                            'value' => true
						                            ]
					                            ] );

					$fields['gallery'][] = Field::make( 'radio_image', 'media_gallery_overlay_show_individual', esc_html__( 'Show overlay on', 'typer-pro' ) )
					                            ->set_options( Helper::instance()->get_carbon_overlay_show_options() )
					                            ->set_default_value( 'single' )
					                            ->set_classes( 'no-flex' )
					                            ->set_conditional_logic( [
						                            [
							                            'field' => 'media_gallery_overwrite_individual',
							                            'value' => true
						                            ],
						                            [
							                            'field'   => 'media_gallery_overlay_individual',
							                            'value'   => 'none',
							                            'compare' => '!='
						                            ]
					                            ] );
				}

				$fields['breadcat'] = [];

				$fields['breadcat'][] = Field::make( 'checkbox', 'media_catbread_overwrite_individual', esc_html__( 'Overwrite Breadcrumbs Customizer settings', 'typer-pro' ) );

				$fields['breadcat'][] = Field::make( 'radio_image', 'media_catbread_type_individual', esc_html__( 'Style', 'typer-pro' ) )
				                             ->set_options( Helper::instance()->get_carbon_media_meta_options() )
				                             ->set_default_value( 'category' )
				                             ->set_classes( 'no-flex' )
				                             ->set_conditional_logic( [
					                             [
						                             'field' => 'media_catbread_overwrite_individual',
						                             'value' => true
					                             ]
				                             ] );

				$fields['breadcat'][] = Field::make( 'select', 'media_catbread_animation_type_individual', esc_html__( 'Animation', 'typer-pro' ) )
				                             ->set_help_text( esc_html__( 'Choose your entry animation type (only when featured content)', 'typer-pro' ) )
				                             ->set_options( $fade_options )
				                             ->set_default_value( 'fadeInDown' )
				                             ->set_conditional_logic( [
					                             [
						                             'field' => 'media_catbread_overwrite_individual',
						                             'value' => true
					                             ],
					                             [
						                             'field'   => 'media_catbread_type_individual',
						                             'value'   => [ 'none' ],
						                             'compare' => 'NOT IN'
					                             ]
				                             ] );

				$fields['title'] = [];

				$fields['title'][] = Field::make( 'checkbox', 'media_title_overwrite_individual', esc_html__( 'Overwrite Title Customizer settings', 'typer-pro' ) );

				$fields['title'][] = Field::make( 'radio_image', 'media_title_position_individual', esc_html__( 'Style', 'typer-pro' ) )
				                          ->set_options( Helper::instance()->get_carbon_media_title_options() )
				                          ->set_default_value( 'over' )
				                          ->set_classes( 'no-flex' )
				                          ->set_conditional_logic( [
					                          [
						                          'field' => 'media_title_overwrite_individual',
						                          'value' => true
					                          ]
				                          ] );

				$fields['title'][] = Field::make( 'radio_image', 'media_title_over_alignment_individual', esc_html__( 'Alignment', 'typer-pro' ) )
				                          ->set_options( Helper::instance()->get_carbon_media_alignment_options() )
				                          ->set_default_value( 'default' )
				                          ->set_classes( 'no-flex' )
				                          ->set_conditional_logic( [
					                          [
						                          'field' => 'media_title_overwrite_individual',
						                          'value' => true
					                          ],
					                          [
						                          'field'   => 'media_title_position_individual',
						                          'value'   => 'title-over',
						                          'compare' => '='
					                          ]
				                          ] );

				$fields['title'][] = Field::make( 'radio_image', 'media_title_left_alignment_individual', esc_html__( 'Alignment', 'typer-pro' ) )
				                          ->set_options( Helper::instance()->get_carbon_media_alignment_options() )
				                          ->set_default_value( 'default' )
				                          ->set_classes( 'no-flex' )
				                          ->set_conditional_logic( [
					                          [
						                          'field' => 'media_title_overwrite_individual',
						                          'value' => true
					                          ],
					                          [
						                          'field'   => 'media_title_position_individual',
						                          'value'   => 'half',
						                          'compare' => '='
					                          ]
				                          ] );

				$fields['title'][] = Field::make( 'radio_image', 'media_title_above_below_alignment_individual', esc_html__( 'Alignment', 'typer-pro' ) )
				                          ->set_options( Helper::instance()->get_carbon_media_alignment_options( true ) )
				                          ->set_default_value( 'default' )
				                          ->set_classes( 'no-flex' )
				                          ->set_conditional_logic( [
					                          [
						                          'field' => 'media_title_overwrite_individual',
						                          'value' => true
					                          ],
					                          [
						                          'field'   => 'media_title_position_individual',
						                          'value'   => 'title-over',
						                          'compare' => '!='
					                          ],
					                          [
						                          'field'   => 'media_title_position_individual',
						                          'value'   => 'half',
						                          'compare' => '!='
					                          ]
				                          ] );

				$fields['title'][] = Field::make( 'radio_image', 'media_title_size_individual', esc_html__( 'Size', 'typer-pro' ) )
				                          ->set_options( Helper::instance()->get_carbon_media_title_size_options() )
				                          ->set_default_value( 'default' )
				                          ->set_classes( 'no-flex' )
				                          ->set_conditional_logic( [
					                          [
						                          'field' => 'media_title_overwrite_individual',
						                          'value' => true
					                          ]
				                          ] );

				$fields['title'][] = Field::make( 'select', 'media_title_animation_type_individual', esc_html__( 'Animation', 'typer-pro' ) )
				                          ->set_help_text( esc_html__( 'Choose your entry animation type (only when featured content)', 'typer-pro' ) )
				                          ->set_options( $fade_options )
				                          ->set_default_value( 'fadeIn' )
				                          ->set_conditional_logic( [
					                          [
						                          'field' => 'media_title_overwrite_individual',
						                          'value' => true
					                          ]
				                          ] );

				$fields['meta'] = [];

				$fields['meta'][] = Field::make( 'checkbox', 'media_meta_overwrite_individual', esc_html__( 'Overwrite Meta Customizer settings', 'typer-pro' ) );

				$fields['meta'][] = Field::make( 'checkbox', 'media_meta_show_individual', esc_html__( 'Show', 'typer-pro' ) )
				                         ->set_default_value( 'yes' )
				                         ->set_help_text( esc_html__( 'Show post meta', 'typer-pro' ) )
				                         ->set_conditional_logic( [
					                         [
						                         'field' => 'media_meta_overwrite_individual',
						                         'value' => true
					                         ]
				                         ] );

				$meta_items          = [
					'avatar'  => esc_html__( 'Show author avatar', 'typer-pro' ),
					'author'  => esc_html__( 'Show author name', 'typer-pro' ),
					'date'    => esc_html__( 'Show posted on date', 'typer-pro' ),
					'reading' => esc_html__( 'Show reading time', 'typer-pro' )
				];
				$meta_items_defaults = [ 'avatar', 'author', 'date', 'reading' ];

				if ( class_exists( '\FUP\FupPlugin' ) ) {
					$meta_items['bookmark'] = esc_html__( 'Show bookmark button', 'typer-pro' );
					$meta_items_defaults[]  = 'bookmark';
				}

				$fields['meta'][] = Field::make( 'multiselect', 'media_meta_items_individual', esc_html__( 'Items', 'typer-pro' ) )
				                         ->set_options( $meta_items )
				                         ->set_default_value( $meta_items_defaults )
				                         ->set_conditional_logic( [
					                         [
						                         'field' => 'media_meta_overwrite_individual',
						                         'value' => true
					                         ],
					                         [
						                         'field' => 'media_meta_show_individual',
						                         'value' => true
					                         ]
				                         ] );

				if ( class_exists( '\FUP\FupPlugin' ) ) {
					$fields['meta'][] = Field::make( 'checkbox', 'fup_media_meta_action_individual', esc_html__( 'Show', 'typer-pro' ) )
					                         ->set_default_value( 'yes' )
					                         ->set_help_text( esc_html__( 'Show bookmark button', 'typer-pro' ) )
					                         ->set_conditional_logic( [
						                         [
							                         'field' => 'media_meta_overwrite_individual',
							                         'value' => true
						                         ],
						                         [
							                         'field' => 'media_meta_show_individual',
							                         'value' => true
						                         ]
					                         ] );
				}

				$fields['parallax'] = [];

				$fields['parallax'][] = Field::make( 'checkbox', 'media_shapes_overwrite_individual', esc_html__( 'Overwrite Parallax Customizer settings', 'typer-pro' ) );

				$fields['parallax'][] = Field::make( 'checkbox', 'media_shapes_show_individual', esc_html__( 'Show', 'typer-pro' ) )
				                             ->set_help_text( esc_html__( 'Show parallax shapes or not', 'typer-pro' ) )
				                             ->set_value( 'no' )
				                             ->set_conditional_logic( [
					                             [
						                             'field' => 'media_shapes_overwrite_individual',
						                             'value' => true
					                             ]
				                             ] );

				$fields['default-listing'] = [];

				$fields['default-listing'][] = Field::make( 'checkbox', 'blog_post_default_listing_overwrite_individual', esc_html__( 'Overwrite Default Listing Customizer settings', 'typer-pro' ) );

				$fields['default-listing'][] = Field::make( 'radio', 'blog_post_listing_thumb_position_individual', esc_html__( 'Image/Video position', 'typer-pro' ) )
				                                    ->set_options( Helper::instance()->get_carbon_default_listing_image_options() )
				                                    ->set_default_value( 'right' )
				                                    ->set_conditional_logic( [
					                                    [
						                                    'field' => 'blog_post_default_listing_overwrite_individual',
						                                    'value' => true
					                                    ]
				                                    ] );

				$fields['big-listing'] = [];

				$fields['big-listing'][] = Field::make( 'checkbox', 'blog_post_big_listing_overwrite_individual', esc_html__( 'Overwrite Big Listing Customizer settings', 'typer-pro' ) );

				$fields['big-listing'][] = Field::make( 'radio_image', 'blog_post_thumbnail_list_big_individual', esc_html__( 'Image/Gallery/Video width', 'typer-pro' ) )
				                                ->set_options( Helper::instance()->get_carbon_masonry_big_listing_image_options() )
				                                ->set_default_value( 'normal' )
				                                ->set_classes( 'no-flex' )
				                                ->set_conditional_logic( [
					                                [
						                                'field' => 'blog_post_big_listing_overwrite_individual',
						                                'value' => true
					                                ]
				                                ] );


				$fields['masonry-listing'] = [];

				$fields['masonry-listing'][] = Field::make( 'checkbox', 'blog_post_masonry_listing_overwrite_individual', esc_html__( 'Overwrite Masonry Listing Customizer settings', 'typer-pro' ) );

				$fields['masonry-listing'][] = Field::make( 'radio_image', 'blog_post_thumbnail_individual', esc_html__( 'Image/Video width', 'typer-pro' ) )
				                                    ->set_options( Helper::instance()->get_carbon_masonry_listing_image_options() )
				                                    ->set_default_value( 'normal' )
				                                    ->set_classes( 'no-flex' )
				                                    ->set_conditional_logic( [
					                                    [
						                                    'field' => 'blog_post_masonry_listing_overwrite_individual',
						                                    'value' => true
					                                    ]
				                                    ] );

				$fields['grid'] = [];

				$fields['grid'][] = Field::make( 'checkbox', 'blog_post_grid_listing_overwrite_individual', esc_html__( 'Overwrite Grid Listing Customizer settings', 'typer-pro' ) );

				$fields['grid'][] = Field::make( 'radio_image', 'blog_post_thumbnail_grid_individual', esc_html__( 'Image/Video width', 'typer-pro' ) )
				                         ->set_options( Helper::instance()->get_carbon_masonry_listing_image_options() )
				                         ->set_default_value( 'normal' )
				                         ->set_classes( 'no-flex' )
				                         ->set_conditional_logic( [
					                         [
						                         'field' => 'blog_post_grid_listing_overwrite_individual',
						                         'value' => true
					                         ]
				                         ] );

				$fields['social'] = [];

				$fields['social'][] = Field::make( 'checkbox', 'blog_social_box_overwrite_individual', esc_html__( 'Overwrite Social Customizer settings', 'typer-pro' ) );

				$fields['social'][] = Field::make( 'checkbox', 'blog_show_social_box_individual', esc_html__( 'Show', 'typer-pro' ) )
				                           ->set_help_text( esc_html__( 'Show social box on post', 'typer-pro' ) )
				                           ->set_value( 'yes' )
				                           ->set_conditional_logic( [
					                           [
						                           'field' => 'blog_social_box_overwrite_individual',
						                           'value' => true
					                           ]
				                           ] );

				$fields['social'][] = Field::make( 'checkbox', 'blog_force_social_box_top_individual', esc_html__( 'Force display on top', 'typer-pro' ) )
				                           ->set_help_text( esc_html__( 'Force social box to stay on top when no sidebar', 'typer-pro' ) )
				                           ->set_value( 'no' )
				                           ->set_conditional_logic( [
					                           [
						                           'field' => 'blog_social_box_overwrite_individual',
						                           'value' => true
					                           ],
					                           [
						                           'field' => 'blog_show_social_box_individual',
						                           'value' => true
					                           ]
				                           ] );

				foreach ( $fields as $key => $props ) {
					if ( isset( $tabs[ $key ] ) ) {
						$container->add_tab( $tabs[ $key ], $props );
					}
				}

			}

		}
	}

	/**
	 * Add fields in Gutenberg
	 */
	public function register_post_fields() {
		if ( class_exists( 'Carbon_Fields\Container' ) && class_exists( 'Carbon_Fields\Field' ) ) {
			Container::make( 'post_meta', esc_html__( 'Sticky sidebars', 'typer-pro' ) )
			         ->set_context( 'side' )
			         ->add_fields( [
				         Field::make( 'checkbox', 'sidebar_primary_sticky', __( 'Primary sidebar sticky' ) ),
				         Field::make( 'checkbox', 'sidebar_secondary_sticky', __( 'Secondary sidebar sticky' ) )
			         ] );

			Container::make( 'post_meta', esc_html__( 'Media Gallery', 'typer-pro' ) )
			         ->where( 'post_type', '=', 'post' )
			         ->where( 'post_format', '=', 'gallery' )
			         ->set_context( 'side' )
			         ->add_fields( [
				         Field::make( 'media_gallery', 'sq_post_gallery', esc_html__( 'Images', 'typer-pro' ) )
				              ->set_type( 'image' )
				              ->set_duplicates_allowed( false )
			         ] );

			Container::make( 'post_meta', esc_html__( 'Video Media', 'typer-pro' ) )
			         ->where( 'post_type', '=', 'post' )
			         ->where( 'post_format', '=', 'video' )
			         ->set_context( 'side' )
			         ->add_fields( [
				         Field::make( 'radio', 'sq_post_video_type', __( 'Video Type', 'typer-pro' ) )
				              ->set_options( [
					              'hosted' => esc_html__( 'Hosted', 'typer-pro' ),
					              'other'  => esc_html__( 'Youtube or Vimeo', 'typer-pro' )
				              ] )
				              ->set_default_value( 'other' ),

				         Field::make( 'file', 'sq_post_video_file', esc_html__( 'Hosted', 'typer-pro' ) )
				              ->set_type( 'video' )
				              ->set_conditional_logic( [
					              [
						              'field'   => 'sq_post_video_type',
						              'value'   => 'hosted',
						              'compare' => '='
					              ]
				              ] ),

				         Field::make( 'checkbox', 'sq_post_video_illustration', esc_html__( 'Illustration video with autoplay', 'typer-pro' ) )
				              ->set_conditional_logic( [
					              [
						              'field'   => 'sq_post_video_type',
						              'value'   => 'hosted',
						              'compare' => '='
					              ]
				              ] ),

				         Field::make( 'text', 'sq_post_video_other', esc_html__( 'Youtube/Vimeo', 'typer-pro' ) )
				              ->set_conditional_logic( [
					              [
						              'field'   => 'sq_post_video_type',
						              'value'   => 'other',
						              'compare' => '='
					              ]
				              ] ),

				         Field::make( 'checkbox', 'sq_post_video_modal', esc_html__( 'Play in modal', 'typer-pro' ) )
				              ->set_default_value( 'yes' )
			         ] );

			Container::make( 'post_meta', esc_html__( 'Audio media', 'typer-pro' ) )
			         ->where( 'post_type', '=', 'post' )
			         ->where( 'post_format', '=', 'audio' )
			         ->set_context( 'side' )
			         ->add_fields( [
				         Field::make( 'file', 'sq_post_audio', esc_html__( 'Audio', 'typer-pro' ) )
				              ->set_type( 'audio' )
			         ] );
		}
	}

}

PostOptions::instance();
