<?php

namespace TyperPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class TyperPro
 * @package TyperPro
 */
class TyperPro {

	/**
	 * @var null
	 */
	public static $instance;

	/**
	 * @return TyperPro|null
	 */
	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function __construct() {
		require_once TYPER_PRO_CORE_PATH . '/ThemeInfo.php';
		require_once TYPER_PRO_CORE_PATH . '/Helper.php';
		require_once TYPER_PRO_CORE_PATH . '/carbon/PostOptions.php';
		require_once TYPER_PRO_CORE_PATH . '/customizer/BlogOptions.php';
		require_once TYPER_PRO_CORE_PATH . '/customizer/CommentsOptions.php';
		require_once TYPER_PRO_CORE_PATH . '/customizer/FeaturedContentOptions.php';
		require_once TYPER_PRO_CORE_PATH . '/customizer/PerformanceOptions.php';
		require_once TYPER_PRO_CORE_PATH . '/customizer/PostListingOptions.php';
		require_once TYPER_PRO_CORE_PATH . '/elements/loader.php';
		require_once TYPER_PRO_CORE_PATH . '/settings/Settings.php';
		require_once TYPER_PRO_CORE_PATH . '/settings/Modules.php';
		require_once TYPER_PRO_CORE_PATH . '/settings/modules/AdsManager.php';

		add_filter( 'typer_theme_cutomizer_sections', [ $this, 'add_customizer_sections' ], 10, 1 );
		add_filter( 'typer_theme_settings', [ $this, 'add_customizer_autoload' ], 10, 1 );


	}

	public function add_customizer_sections( $sections ) {
		$sections['\TyperPro\Customizer\BlogOptions']            = 50;
		$sections['\TyperPro\Customizer\CommentsOptions']        = 100;
		$sections['\TyperPro\Customizer\FeaturedContentOptions'] = 60;
		$sections['\TyperPro\Customizer\PerformanceOptions']     = 110;
		$sections['\TyperPro\Customizer\PostListingOptions']     = 55;

		return $sections;
	}

	public function add_customizer_autoload( $sq ) {

		$sq['set']['media_separator_10_general'] = [
			'section' => 'svq_section_blog_post_nav',
			'type'    => 'sq-control-separator',
			'label'   => esc_html__( 'Autoload Next Post', 'typer-pro' ),
		];

		$sq['set']['blog_autoload_next_post_general'] = [
			'section'     => 'svq_section_blog_post_nav',
			'type'        => 'switch',
			'choices'     => Helper::instance()->get_switch_options(),
			'default'     => '0',
			'title'       => esc_html__( 'Autoload Next Post', 'typer-pro' ),
			'description' => esc_html__( 'Enable infinite scroll on post page. It will automatically load the previous post. Please note that Next/Prev posts navigation and Related posts are disabled while this option is enabled.', 'typer-pro' ),
		];

		return $sq;

	}

}

TyperPro::instance();
