<?php

namespace TyperPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class Helper
 * @package TyperPro
 */
class Helper {

	/**
	 * @var null
	 */
	public static $instance = null;

	/**
	 * @var
	 */
	private $customizer_img_path;

	/**
	 * @return Helper|null
	 */
	public static function instance() {
		if ( self::$instance === null ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function __construct() {
		$this->customizer_img_path = get_template_directory_uri() . '/assets/img/wp-customizer/';
	}

	public function get_customizer_img_path() {
		return $this->customizer_img_path;
	}

	public function get_post_formats() {
		return [
			'general',
			'standard',
			'image',
			'quote',
			'audio',
			'video',
			'gallery'
		];
	}

	public function get_switch_options() {
		return [
			'1' => esc_html__( 'On', 'typer-pro' ),
			'0' => esc_html__( 'Off', 'typer-pro' ),
		];
	}

	public function get_thumbnail_size_options_masonry() {
		return [
			'normal' => [
				'img' => $this->customizer_img_path . 'post-image-normal.svg',
				'alt' => esc_html__( 'Normal', 'typer-pro' )
			],
			'wide'   => [
				'img' => $this->customizer_img_path . 'post-image-wide.svg',
				'alt' => esc_html__( 'Wide', 'typer-pro' )
			]
		];
	}

	public function get_thumbnail_size_options_list_big() {
		return [
			'normal' => [
				'img' => $this->customizer_img_path . 'post-image-normal-big.svg',
				'alt' => esc_html__( 'Normal', 'typer-pro' )
			],
			'wide'   => [
				'img' => $this->customizer_img_path . 'post-image-wide-big.svg',
				'alt' => esc_html__( 'Wide', 'typer-pro' )
			]
		];
	}

	public function get_thumbnail_position_options() {
		return [
			'left'  => esc_html__( 'Left', 'typer-pro' ),
			'right' => esc_html__( 'Right', 'typer-pro' )
		];
	}

	public function get_title_color_options() {
		return [
			'dark'  => [
				'img' => $this->customizer_img_path . 'mp-text-color-white.svg',
				'alt' => esc_html__( 'White', 'typer-pro' )
			],
			'light' => [
				'img' => $this->customizer_img_path . 'mp-text-color-black.svg',
				'alt' => esc_html__( 'Black', 'typer-pro' )
			]
		];
	}

	public function get_media_meta_options() {
		return [
			'none'                => [
				'img' => $this->customizer_img_path . 'no-category-breadcrumb.svg',
				'alt' => esc_html__( 'No categories, no breadcrumbs', 'typer-pro' )
			],
			'category'            => [
				'img' => $this->customizer_img_path . 'has-category.svg',
				'alt' => esc_html__( 'Categories only', 'typer-pro' )
			],
			'breadcrumb'          => [
				'img' => $this->customizer_img_path . 'has-breadcrumb.svg',
				'alt' => esc_html__( 'Breadcrumbs only', 'typer-pro' )
			],
			'category-breadcrumb' => [
				'img' => $this->customizer_img_path . 'has-category-breadcrumb.svg',
				'alt' => esc_html__( 'Categories and breadcrumbs', 'typer-pro' )
			]
		];
	}

	public function get_media_title_position_options() {
		return [
			'title-over'  => [
				'img' => $this->customizer_img_path . 'title-over-image.svg',
				'alt' => esc_html__( 'Over image', 'typer-pro' )
			],
			'half'        => [
				'img' => $this->customizer_img_path . 'title-on-left-image.svg',
				'alt' => esc_html__( 'Left of image', 'typer-pro' )
			],
			'title-above' => [
				'img' => $this->customizer_img_path . 'title-above-image.svg',
				'alt' => esc_html__( 'Above image', 'typer-pro' )
			],
			'title-below' => [
				'img' => $this->customizer_img_path . 'title-below-image.svg',
				'alt' => esc_html__( 'Below image', 'typer-pro' )
			],
		];
	}

	public function get_featured_media_title_position_options() {
		return [
			'title-over'  => [
				'img' => $this->customizer_img_path . 'title-over-image.svg',
				'alt' => esc_html__( 'Over image', 'typer-pro' )
			],
			'half'        => [
				'img' => $this->customizer_img_path . 'title-on-left-image.svg',
				'alt' => esc_html__( 'Left of image', 'typer-pro' )
			]
		];
	}

	public function get_media_title_alignment_options( $simple = false ) {
		if ( $simple ) {
			return [
				'default' => [
					'img' => $this->customizer_img_path . 'title-align-default.svg',
					'alt' => esc_html__( 'Default', 'typer-pro' )
				],
				'center'  => [
					'img' => $this->customizer_img_path . 'title-center-horizontally.svg',
					'alt' => esc_html__( 'Center horizontally', 'typer-pro' )
				],
			];
		}

		return [
			'default'       => [
				'img' => $this->customizer_img_path . 'title-align-default.svg',
				'alt' => esc_html__( 'Default', 'typer-pro' )
			],
			'center'        => [
				'img' => $this->customizer_img_path . 'title-center-horizontally.svg',
				'alt' => esc_html__( 'Center horizontally', 'typer-pro' )
			],
			'middle'        => [
				'img' => $this->customizer_img_path . 'title-center-vertically.svg',
				'alt' => esc_html__( 'Center vertically', 'typer-pro' )
			],
			'middle-center' => [
				'img' => $this->customizer_img_path . 'title-center-vertically-horizontally.svg',
				'alt' => esc_html__( 'Center horizontally and vertically', 'typer-pro' )
			]
		];
	}

	public function get_media_title_size_options() {
		return [
			'default' => [
				'img' => $this->customizer_img_path . 'title-size-normal.svg',
				'alt' => esc_html__( 'Normal', 'typer-pro' )
			],
			'large'   => [
				'img' => $this->customizer_img_path . 'title-size-large.svg',
				'alt' => esc_html__( 'Large', 'typer-pro' )
			]
		];
	}

	public function get_media_width_options() {
		return [
			'wide'       => [
				'img' => $this->customizer_img_path . 'cover-image-wide.svg',
				'alt' => esc_html__( 'Wide', 'typer-pro' )
			],
			'full-width' => [
				'img' => $this->customizer_img_path . 'cover-image-full-width.svg',
				'alt' => esc_html__( 'Full width', 'typer-pro' )

			]
		];
	}

	public function get_media_background_type_options() {
		return [
			'cover'   => [
				'img' => $this->customizer_img_path . 'bg-cover.svg',
				'alt' => esc_html__( 'Cover', 'typer-pro' )
			],
			'contain' => [
				'img' => $this->customizer_img_path . 'bg-contain.svg',
				'alt' => esc_html__( 'Contain', 'typer-pro' )
			]
		];
	}

	public function get_media_gallery_item_width_options() {
		return [
			'portrait' => [
				'img' => $this->customizer_img_path . 'gallery-img-portrait.svg',
				'alt' => esc_html__( 'Multiple slides', 'typer-pro' )
			],
			'wide'     => [
				'img' => $this->customizer_img_path . 'gallery-img-wide.svg',
				'alt' => esc_html__( 'Single slide', 'typer-pro' )
			]
		];
	}

	public function get_media_meta_items_options() {
		return [
			'avatar'  => esc_html__( 'Show author avatar', 'typer-pro' ),
			'author'  => esc_html__( 'Show author name', 'typer-pro' ),
			'date'    => esc_html__( 'Show posted on date', 'typer-pro' ),
			'reading' => esc_html__( 'Show reading time', 'typer-pro' )
		];
	}

	public function get_color_options() {
		return [
			'none'       => esc_html__( 'None', 'typer-pro' ),
			'primary'    => esc_html__( 'Primary color (as defined)', 'typer-pro' ),
			'bottom'     => esc_html__( 'Bottom (Gradient)', 'typer-pro' ),
			'top-bottom' => esc_html__( 'Top-bottom (Gradient)', 'typer-pro' ),
			'red'        => esc_html__( 'Red', 'typer-pro' ),
			'pink'       => esc_html__( 'Pink', 'typer-pro' ),
			'purple'     => esc_html__( 'Purple', 'typer-pro' ),
			'indigo'     => esc_html__( 'Indigo', 'typer-pro' ),
			'blue'       => esc_html__( 'Blue', 'typer-pro' ),
			'cyan'       => esc_html__( 'Cyan', 'typer-pro' ),
			'teal'       => esc_html__( 'Teal', 'typer-pro' ),
			'green'      => esc_html__( 'Green', 'typer-pro' ),
			'lime'       => esc_html__( 'Lime', 'typer-pro' ),
			'yellow'     => esc_html__( 'Yellow', 'typer-pro' ),
			'orange'     => esc_html__( 'Orange', 'typer-pro' ),
			'brown'      => esc_html__( 'Brown', 'typer-pro' ),
			'black'      => esc_html__( 'Black', 'typer-pro' )
		];
	}

	public function get_color_overlay_options() {
		return [
			'both'    => [
				'img' => $this->customizer_img_path . 'show-on-both.svg',
				'alt' => esc_html__( 'Listing and single post', 'typer-pro' )
			],
			'listing' => [
				'img' => $this->customizer_img_path . 'show-on-listing.svg',
				'alt' => esc_html__( 'Listing only', 'typer-pro' )
			],
			'single'  => [
				'img' => $this->customizer_img_path . 'show-on-single.svg',
				'alt' => esc_html__( 'Single post only', 'typer-pro' )
			]
		];
	}

	public function get_fade_options() {
		return [
			'none'       => esc_html__( 'None', 'typer-pro' ),
			'fadeIn'     => esc_html__( 'FadeIn', 'typer-pro' ),
			'fadeInUp'   => esc_html__( 'FadeInUp', 'typer-pro' ),
			'fadeInDown' => esc_html__( 'FadeInDown', 'typer-pro' ),
		];
	}

	public function get_carbon_resolution_options() {
		return [
			'1' => esc_html__( 'Off', 'typer-pro' ),
			'2' => esc_html__( 'Up to Mobile', 'typer-pro' ),
			'3' => esc_html__( 'Up to Tablet', 'typer-pro' ),
			'4' => esc_html__( 'Up to Desktop', 'typer-pro' ),
		];
	}

	public function get_carbon_dark_light_options() {
		return [
			'dark'  => $this->customizer_img_path . 'mp-text-color-white.svg',
			'light' => $this->customizer_img_path . 'mp-text-color-black.svg'
		];
	}

	public function get_carbon_image_width_options() {
		return [
			'wide'       => $this->customizer_img_path . 'cover-image-wide.svg',
			'full-width' => $this->customizer_img_path . 'cover-image-full-width.svg'
		];
	}

	public function get_carbon_overlay_show_options() {
		return [
			'both'    => $this->customizer_img_path . 'show-on-both.svg',
			'listing' => $this->customizer_img_path . 'show-on-listing.svg',
			'single'  => $this->customizer_img_path . 'show-on-single.svg'
		];
	}

	public function get_carbon_image_display_options() {
		return [
			'cover'   => $this->customizer_img_path . 'bg-cover.svg',
			'contain' => $this->customizer_img_path . 'bg-contain.svg'
		];
	}

	public function get_carbon_gallery_display_options() {
		return [
			'portrait' => $this->customizer_img_path . 'gallery-img-portrait.svg',
			'wide'     => $this->customizer_img_path . 'gallery-img-wide.svg'
		];
	}

	public function get_carbon_media_meta_options() {
		return [
			'none'                => $this->customizer_img_path . 'no-category-breadcrumb.svg',
			'category'            => $this->customizer_img_path . 'has-category.svg',
			'breadcrumb'          => $this->customizer_img_path . 'has-breadcrumb.svg',
			'category-breadcrumb' => $this->customizer_img_path . 'has-category-breadcrumb.svg'
		];
	}

	public function get_carbon_media_title_options() {
		return [
			'title-over'  => $this->customizer_img_path . 'title-over-image.svg',
			'half'        => $this->customizer_img_path . 'title-on-left-image.svg',
			'title-above' => $this->customizer_img_path . 'title-above-image.svg',
			'title-below' => $this->customizer_img_path . 'title-below-image.svg'
		];
	}

	public function get_carbon_media_alignment_options( $simple = false ) {
		if ( $simple ) {
			return [
				'default' => $this->customizer_img_path . 'title-align-default.svg',
				'center'  => $this->customizer_img_path . 'title-center-horizontally.svg'
			];
		}

		return [
			'default'       => $this->customizer_img_path . 'title-align-default.svg',
			'center'        => $this->customizer_img_path . 'title-center-horizontally.svg',
			'middle'        => $this->customizer_img_path . 'title-center-vertically.svg',
			'middle-center' => $this->customizer_img_path . 'title-center-vertically-horizontally.svg'
		];
	}

	public function get_carbon_media_title_size_options() {
		return [
			'default' => $this->customizer_img_path . 'title-size-normal.svg',
			'large'   => $this->customizer_img_path . 'title-size-large.svg'
		];
	}

	public function get_carbon_masonry_listing_image_options() {
		return [
			'normal' => $this->customizer_img_path . 'post-image-normal.svg',
			'wide'   => $this->customizer_img_path . 'post-image-wide.svg'
		];
	}

	public function get_carbon_masonry_big_listing_image_options() {
		return [
			'normal' => $this->customizer_img_path . 'post-image-normal-big.svg',
			'wide'   => $this->customizer_img_path . 'post-image-wide-big.svg'
		];
	}

	public function get_carbon_default_listing_image_options() {
		return [
			'left'  => esc_html__( 'Left', 'typer-pro' ),
			'right' => esc_html__( 'Right', 'typer-pro' )
		];
	}

	public function get_carbon_tabs() {
		return [
			'media-panel'     => esc_html__( 'Media Panel', 'typer-pro' ),
			'breadcat'        => esc_html__( 'Categories and Breadcrumbs', 'typer-pro' ),
			'title'           => esc_html__( 'Title', 'typer-pro' ),
			'image'           => esc_html__( 'Image', 'typer-pro' ),
			'video'           => esc_html__( 'Video', 'typer-pro' ),
			'gallery'         => esc_html__( 'Gallery', 'typer-pro' ),
			'meta'            => esc_html__( 'Meta', 'typer-pro' ),
			'parallax'        => esc_html__( 'Parallax', 'typer-pro' ),
			'default-listing' => esc_html__( 'Default Listing', 'typer-pro' ),
			'big-listing'     => esc_html__( 'Big Listings', 'typer-pro' ),
			'masonry-listing' => esc_html__( 'Masonry Listing', 'typer-pro' ),
			'grid'            => esc_html__( 'Grid Listings', 'typer-pro' ),
			'social'          => esc_html__( 'Social box', 'typer-pro' )
		];
	}

}
