var TPBannerManager = TPBannerManager || {};

(function ($) {

    // USE STRICT
    "use strict";

    TPBannerManager.fn = {
        init: function () {
            TPBannerManager.fn.addBanner();
            TPBannerManager.fn.removeBanner();
        },

        addBanner: function () {
            $('.svq-more-button').on('click', function (e) {
                e.preventDefault();

                var key = $(this).attr('data-counter');

                $('#svq-banners').append('<div class="sqp-border sqp-border-solid sqp-border-gray-200 sqp-rounded sqp-p-4 sqp-relative">' +
                    '<input type="hidden" name="banner[' + key + '][id]" value="">' +
                    '' +
                    '<div class="sqp-mb-4">' +
                    '<label for="name-' + key + '" class="sqp-block sqp-text-gray-700 sqp-text-sm sqp-font-bold sqp-mb-2">' + $(this).data('label-name') + '</label>' +
                    '<input type="text" name="banner[' + key + '][name]" id="name-' + key + '" value="" class="sqp-appearance-none sqp-border sqp-rounded sqp-w-full sqp-py-2 sqp-px-3 sqp-text-gray-700 sqp-leading-tight focus:sqp-outline-none" required>' +
                    '</div>' +
                    '<div>' +
                    '<label for="content-' + key + '" class="sqp-block sqp-text-gray-700 sqp-text-sm sqp-font-bold sqp-mb-2">' + $(this).data('label-content') + '</label>' +
                    '<textarea name="banner[' + key + '][content]" id="content-' + key + '" rows="5" class="sqp-appearance-none sqp-border sqp-rounded sqp-w-full sqp-py-2 sqp-px-3 sqp-text-gray-700 sqp-leading-tight focus:sqp-outline-none" required></textarea>' +
                    '</div>' +
                    '<button type="button" class="svq-remove-button sqp-absolute sqp-top-0 sqp-right-0 sqp-mt-4 sqp-mr-4 sqp-bg-transparent sqp-border-0 sqp-p-0 sqp-cursor-pointer">' +
                    '<span class="dashicons dashicons-no"></span>' +
                    '</button>' +
                    '</div>');
            });
        },

        removeBanner: function () {
            $('#svq-banners').on('click', '.svq-remove-button', function (e) {
                e.preventDefault();

                $(this).parent().remove();
            });

            $('.svq-remove-button').on('click', function (e) {
                e.preventDefault();

                $(this).parent().remove();
            });
        }
    };

    TPBannerManager.fn.init();

})(jQuery);
