<?php

namespace Seventhqueen\Typer;

$header_classes           = 'svq-header-section';
$header_container_classes = 'navbar-container';

if ( typer()->get_option( 'header_sticky' ) ) {
	$header_classes .= ' svq-header--sticky';
}

if ( typer()->get_option( 'header_always_dark' ) ) {
	$header_classes           .= ' theme-color-dark';
	$header_container_classes .= ' ';
} else {
	$header_classes .= ' theme-color-light';
}

$header_classes .= ' svq-menu--' . typer()->get_option( 'header_menu_position' );
?>

<div id="header" class="<?php echo esc_attr( $header_classes ) ?>">
	<?php if ( is_single() && typer()->get_blog_option( 'progressive_bar' ) ) : ?>
		<div class="svq-progress-bar">
			<progress value="0" id="progressBar"></progress>
		</div>
	<?php endif; ?>
	<div class="<?php echo esc_attr( $header_container_classes ) ?>">
		<nav class="navbar navbar-expand-lg svq-content--large">
			<div class="ty-logo">
				<?php typer()->the_logo(); ?>
			</div>

			<div class="navbar-custom-toggler collapsed" data-toggle="collapse" data-target="#typerMainMenu"
				 aria-controls="typerMainMenu" aria-expanded="false"
				 aria-label="<?php esc_attr_e( 'Toggle navigation', 'typer' ) ?>" role="button"
				 data-mobile-style="full-height">
				<span></span>
				<span></span>
				<span></span>
			</div>

			<div class="navbar-collapse collapse" id="typerMainMenu">
				<?php typer()->display_primary_nav_menu(); ?>

				<?php do_action( 'typer_header_after_nav' ); ?>

				<?php if ( typer()->get_option( 'header_search' ) ) : ?>
					<form class="form-inline pl-lg-7 my-2 my-lg-0" method="get" id="searchform"
						  action="<?php echo esc_url( home_url( '/' ) ); ?>">
						<div class="ty-search">
							<a href="#" class="btn btn-link btn-search-toggle" data-action="btn-search-toggle">
							<span class="btn--default-state">
								<?php echo typer()->load_icon( 'search', 18 ) ?>
							</span>
								<span class="btn--active-state">
								<?php echo typer()->load_icon( 'close', 18 ) ?>
							</span>
							</a>
							<input class="form-control ty-search-input" type="text"
								   name="s"
								   value="<?php echo esc_attr( get_search_query() ) ?>"
								   placeholder="<?php esc_attr_e( 'What do you want to find?', 'typer' ) ?>"
								   aria-label="<?php esc_attr_e( 'Search', 'typer' ); ?>">
						</div>
					</form>
				<?php endif; ?>
			</div>
		</nav>
	</div>
</div>
