<?php
/**
 * Template part for displaying the footer
 *
 * @package typer
 */

namespace Seventhqueen\Typer;

$show_footer = apply_filters( 'typer_show_footer_widgets', true );

if ( is_404() ) {
	$show_footer = (bool) typer()->get_option( '404_show_footer' );
}

$footer_classes = '';

if ( $show_footer ) {
	$footer_classes .= 'svq-footer-widgets';
}

?>

<footer class="svq-footer-section section-reveal <?php echo esc_attr( $footer_classes ) ?>">
	<div class="svq-content--large">
		<?php if ( $show_footer && typer()->is_any_footer_column_active() ) : ?>
			<?php typer()->get_template_part( 'template-parts/footer/sidebar' ); ?>
		<?php endif; ?>

		<?php typer()->get_template_part( 'template-parts/footer/info' ); ?>
	</div>
</footer>
