<?php

namespace Seventhqueen\Typer;

$postID = get_the_ID();

$video_type = get_post_meta( $postID, '_sq_post_video_type', true );

$player_id          = '';
$player_type        = '';
$media_classes      = [];
$illustration_video = false;

if ( $video_type === 'hosted' ) {
	$video = get_post_meta( $postID, '_sq_post_video_file', true );
	$video = wp_get_attachment_url( $video );

	if ( get_post_meta( $postID, '_sq_post_video_illustration', true ) ) {
		$illustration_video = true;
	}
} else {
	$video = get_post_meta( $postID, '_sq_post_video_other', true );

	if ( strpos( $video, 'youtube.com' ) > 0 || strpos( $video, 'youtu.be' ) > 0 ) {
		preg_match( "#(?<=v=)[a-zA-Z0-9-]+(?=&)|(?<=v\/)[^&\n]+(?=\?)|(?<=v=)[^&\n]+|(?<=youtu.be/)[^&\n]+#", $video, $matches );
		if ( isset( $matches[0] ) && $matches[0] ) {
			$player_id = $matches[0];
		}

		$player_type = 'youtube';
	} elseif ( strpos( $video, 'vimeo.com' ) > 0 ) {
		preg_match( '%^https?:\/\/(?:www\.|player\.)?vimeo.com\/(?:channels\/(?:\w+\/)?|groups\/([^\/]*)\/videos\/|album\/(\d+)\/video\/|video\/|)([a-z0-9#=]+)(?:$|\/|\?)(?:[?]?.*)$%im', $video, $matches );

		if ( isset( $matches[3] ) && $matches[3] ) {
			$player_id = $matches[3];
			$player_id = explode( '#', $player_id );
			$player_id = $player_id[0];
		}

		$player_type = 'vimeo';
	}
}

$media_classes[] = sprintf( 'svq--%s', typer()->get_blog_option( 'media_video_width' ) );
$media_classes   = implode( ' ', $media_classes );

$overlay_classes = [];
$overlay         = typer()->get_blog_option( 'media_video_overlay' );
$overlay_show    = typer()->get_blog_option( 'media_video_overlay_show' );

if ( $overlay !== 'none' && in_array( $overlay_show, [ 'single', 'both' ] ) ) {
	$overlay_classes[] = 'svq-overlay svq-overlay--' . $overlay;
}

if ( $illustration_video ) {
	$overlay_classes[] = 'video-is-loaded';
}

$overlay_classes = implode( ' ', $overlay_classes );

$is_modal          = get_post_meta( $postID, '_sq_post_video_modal', true );
$video_modal_class = '';

if ( $is_modal === 'yes' ) {
	$is_modal          = true;
	$video_modal_class .= 'plyr-no-action';
	\Typer_Assets::instance()->enqueue_fancybox();
} else {
	$is_modal = false;
}

?>

<?php if ( $video ) : ?>
	<?php \Typer_Assets::instance()->enqueue_plyr() ?>

	<figure class="svq-media-video video-reveal <?php echo esc_attr( $media_classes ) ?>">
		<?php if ( $is_modal && typer()->get_blog_option( 'media_title_position' ) !== 'title-over' ) : ?>
			<a class="show-in-modal" data-fancybox="gallery-modal" href="<?php echo esc_url( $video ) ?>">
				<span class="icon icon-caret-right"></span>
				<span class="play-text"><?php esc_html_e( 'Play video', 'typer' ) ?></span>
			</a>
		<?php endif; ?>
		<div class="svq-progressive">
			<?php if ( $is_modal ) : ?>
				<div class="video-overlay-modal"></div>
			<?php endif; ?>
			<div class="aspect-ratio-1-1"></div>
			<div class="svq-progressive__placeholder-video <?php echo esc_attr( $overlay_classes ) ?>">
				<?php if ( $video_type === 'hosted' ) : ?>
					<?php if ( $illustration_video ) : ?>
						<video class="video-illustration lazy-video" autoplay loop muted playsinline>
							<source src="<?php echo esc_url( get_parent_theme_file_uri( 'assets/img/placeholder.mp4' ) ) ?>"
							        data-src="<?php echo esc_url( $video ) ?>" type="video/mp4">
						</video>
						<noscript>
							<video class="video-illustration" autoplay loop muted playsinline>
								<source src="<?php echo esc_url( $video ) ?>" type="video/mp4">
							</video>
						</noscript>
					<?php else: ?>
						<video class="video-plyr lazy-video <?php echo esc_attr( $video_modal_class ) ?>">
							<source src="<?php echo esc_url( get_parent_theme_file_uri( 'assets/img/placeholder.mp4' ) ); ?>"
							        data-src="<?php echo esc_url( $video ) ?>" type="video/mp4">
						</video>
						<noscript>
							<video class="video-plyr">
								<source src="<?php echo esc_url( $video ) ?>" type="video/mp4">
							</video>
						</noscript>
					<?php endif; ?>
				<?php elseif ( $video_type === 'other' && $player_id && $player_type ) : ?>
					<div class="video-plyr video-plyr-alone <?php echo esc_attr( $video_modal_class ) ?>"
					     data-plyr-provider="<?php echo esc_attr( $player_type ) ?>"
					     data-plyr-embed-id="<?php echo esc_attr( $player_id ) ?>"></div>
				<?php endif; ?>
			</div>
		</div>
	</figure>

	<?php if ( $is_modal && typer()->get_blog_option( 'media_title_position' ) === 'title-over' ) : ?>
		<a class="show-in-modal" data-fancybox="gallery-modal" href="<?php echo esc_url( $video ); ?>">
			<span class="icon icon-caret-right"></span>
			<span class="play-text"><?php esc_html_e( 'Play video', 'typer' ) ?></span>
		</a>
	<?php endif; ?>
<?php endif; ?>
