<?php
/**
 * Template part for displaying a post's footer
 *
 * @package typer
 */

namespace Seventhqueen\Typer;

?>

<div class="entry-footer entry-footer--default">
	<?php typer()->get_template_part( 'template-parts/content/entry-actions' ); ?>

	<?php
	if ( is_singular( get_post_type() ) && ! typer()->get_blog_option( 'blog_autoload_next_post', 'general' ) ) {
		// Show post navigation only when the post type is 'post' or has an archive.
		if ( 'post' === get_post_type() || get_post_type_object( get_post_type() )->has_archive ) {
			typer()->custom_post_nav();
		}
	}
	?>

	<?php
	if ( is_single() && get_post_type() === 'post' && typer()->get_option( 'blog_related_posts_enabled' ) && ! typer()->get_blog_option( 'blog_autoload_next_post', 'general' ) ) {
		if ( typer()->get_option( 'blog_related_posts' ) === 'default' ) {
			typer()->get_template_part( 'template-parts/related/by-category' );
		} elseif ( typer()->get_option( 'blog_related_posts' ) === 'author' ) {
			typer()->get_template_part( 'template-parts/related/by-author' );
		}
	}
	?>
</div><!-- .entry-footer -->
