<?php
/**
 * Template part for displaying a post's content
 *
 * @package typer
 */

namespace Seventhqueen\Typer;

?>

<div class="entry-content">
	<?php
	do_action( 'typer_before_single_content' );

	the_content(
		sprintf(
			wp_kses(
			/* translators: %s: Name of current post. Only visible to screen readers */
				__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'typer' ),
				[
					'span' => [
						'class' => [],
					],
				]
			),
			get_the_title()
		)
	);

	wp_link_pages(
		[
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'typer' ),
			'after'  => '</div>',
		]
	);

	do_action( 'typer_after_single_content' );
	?>
</div>
