<?php
/**
 * The template for displaying archive page content
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package typer
 */

namespace Seventhqueen\Typer;

$masonry_classes = [];
$site_layout     = typer()->get_option( 'site_layout_archive' );
$layout_width    = typer()->get_option( 'container_width_archive' );

if ( $site_layout !== 'no-side' || $layout_width === 'small' ) {
	foreach ( typer()->get_option( 'blog_masonry_small_items' ) as $viewport => $value ) {
		$masonry_classes = typer_build_masonry_classes( $masonry_classes, $viewport, $value );
	}
} else {
	foreach ( typer()->get_option( 'blog_masonry_wide_items' ) as $viewport => $value ) {
		$masonry_classes = typer_build_masonry_classes( $masonry_classes, $viewport, $value );
	}
}

$masonry_classes = implode( ' ', $masonry_classes );
\Typer_Assets::instance()->enqueue_masonry();

?>

<?php if ( have_posts() ) : ?>
	<div class="svq-media-masonry">
		<div class="svq-masonry-articles svq-article--list-card <?php echo esc_attr( $masonry_classes ) ?>">
			<div class="svq-grid-sizer"></div>
			<?php

			$media_width = typer()->get_option( 'blog_post_thumbnail' );
			$media_size  = $media_width === 'normal' ? 'typer-img-sm' : 'typer-img-lg';

			$k = 1;
			while ( have_posts() ) {
				the_post();

				if ( $media_width === 'wide' && get_post_format() === 'gallery' ) {
					$media_size = 'auto';
				}

				if ( $media_width !== 'normal' && get_post_format() === 'video' ) {
					$media_aspect_ratio = '16-9';
				} else {
					$media_aspect_ratio = '1-1';
				}

				if ( $k === 1 && typer()->get_option( 'blog_masonry_span' ) ) {
					typer()->set_post_data( 'grid_span', 'svq-masonry-span' );
				}

				typer()->set_post_data( 'media_size', $media_size );
				typer()->set_post_data( 'media_width', $media_width );
				typer()->set_post_data( 'media_aspect_ratio', $media_aspect_ratio );

				do_action( 'typer_masonry_grid_before_box', $k );

				typer()->get_template_part( 'template-parts/archive/article-box' );
				$k ++;
			}

			?>
		</div>

		<?php

		$nav = true;

		if ( isset( $show_navigation ) && is_bool( $show_navigation ) ) {
			$nav = $show_navigation;
		}

		if ( $nav ) {
			echo typer()->get_the_posts_navigation();
		}

		?>

	</div>
<?php else: ?>
	<?php typer()->get_template_part( 'template-parts/content/error/index' ) ?>
<?php endif; ?>
