<?php

namespace Seventhqueen\Typer;

if(!isset($featured_posts)) {
	return;
}

$categories = [];

foreach ( $featured_posts->posts as $item ) {
	$post_categories = wp_get_post_categories( $item->ID );
	if ( is_array( $post_categories ) && isset( $post_categories[0] ) ) {
		$categories = array_unique( array_merge( $categories, [ $post_categories[0] ] ) );
	}
}

$title = typer()->get_option( 'blog_featured_content_title' );

\Typer_Assets::instance()->enqueue_swiper();

$swiper_slide_class = '';

?>

<div class="svq-media-slider svq-media-slider--featured">
	<?php if ( $title ) : ?>
		<div class="heading-title">
			<div class="heading-title-content">
				<h3 class="heading-title-text">
					<?php echo esc_html( $title ) ?>
				</h3>
			</div>
		</div>
	<?php endif; ?>

	<?php if ( ! empty( $categories ) && count( $categories ) > 1 ) : ?>
		<?php
		$categoriesArr = [];
		foreach ( $categories as $cat ) {
			$categoriesArr[] = get_cat_name( $cat );
		}
		$categoriesArr = json_encode( $categoriesArr );
		?>

		<nav class="svq-slider-nav nav-button-style svq-master-carousel"
		     data-slider-categories="<?php echo esc_attr( $categoriesArr ) ?>">
			<ul class="svq-nav-list swiper-wrapper svq-nav-pagination" role="tablist">
			</ul>
		</nav>
	<?php else: ?>
		<?php
		$swiper_slide_class = 'svq-slider-item-visible';
		?>
	<?php endif; ?>

	<div class="svq-slider-for svq-child-carousel">
		<div class="swiper-wrapper">
			<?php for ( $i = 0, $iMax = count( $categories ); $i < $iMax; $i ++ ) : ?>
				<?php

				$extra_slider_class = $i === 0 ? ' swiper-slide-active' : '';

				?>

				<div class="svq-slider-item swiper-slide <?php echo esc_attr( $swiper_slide_class ) ?> <?php echo esc_attr($extra_slider_class) ?>">
					<div class="svq-slider-articles svq-article--list-card section-reveal svq-nested">
						<div class="swiper-wrapper">
							<?php

							$media_width        = 'wide';
							$media_aspect_ratio = '16-9';

							while ( $featured_posts->have_posts() ) {
								$featured_posts->the_post();

								$post_cats = wp_get_post_categories( get_the_ID() );
								$post_cat  = null;
								if ( is_array( $post_cats ) && ! empty( $post_cats ) && isset( $post_cats[0] ) ) {
									$post_cat = $post_cats[0];
								}

								if ( isset( $categories[ $i ] ) && (int) $categories[ $i ] === (int) $post_cat ) {
									if ( get_post_format() === 'gallery' ) {
										$media_size = 'auto';
									} else {
										$media_size = 'typer-img-xl';
									}

									typer()->set_post_data( 'listing_type', 'list-featured' );
									typer()->set_post_data( 'media_size', $media_size );
									typer()->set_post_data( 'media_width', $media_width );
									typer()->set_post_data( 'media_aspect_ratio', $media_aspect_ratio );
									typer()->set_post_data( 'col_classes', 'swiper-slide' );

									typer()->get_template_part( 'template-parts/archive/article-box' );
								}
							}

							wp_reset_postdata();
							?>
						</div>
					</div>
				</div>
			<?php endfor; ?>
		</div>

		<div class="svq-article-btn carousel-navigation">
			<a href="#" class="btn btn-light btn-sm button-ripple slide-to--back">
				<?php echo typer()->load_icon( 'long-arrow-left', 18 ) ?>
			</a>
			<a href="#" class="btn btn-light btn-sm button-ripple btn-icon--right slide-to--next">
				<?php esc_html_e( 'Next', 'typer' ) ?>
				<?php echo typer()->load_icon( 'long-arrow-right', 18 ) ?>
			</a>
		</div>
	</div>
</div>
