<?php

namespace Seventhqueen\Typer;

global $post;

/*
 * Panel classes
 */

$panel_classes = [];

$has_media = typer()->has_media();

if ( ! get_post_format() && ! typer()->get_blog_option( 'media_image_enabled' ) ) {
	$has_media = false;
}

$title_position = typer()->get_option( 'blog_featured_style_2_title_position' );

if ( $has_media ) {
	$panel_classes[] = 'has-featured-image';
	$panel_classes[] = 'svq-panel--' . $title_position;
	$panel_classes[] = 'svq-panel--' . typer()->get_blog_option( 'media_content_color' );

	if ( get_post_format() === 'video' ) {
		$video_type = get_post_meta( get_the_ID(), '_sq_post_video_type', true );

		if ( $video_type === 'hosted' && get_post_meta( get_the_ID(), '_sq_post_video_illustration', true ) ) {
			$panel_classes[] = 'has-illustration-video';
		}
	}
} else {
	$panel_classes[] = 'svq-panel--light';
}

$panel_classes[] = 'svq-panel--off-height';

$panel_classes = implode( ' ', $panel_classes );

/*
 * Article classes
 */

$article_classes   = [];
$article_classes[] = 'entry-header--' . typer()->get_option( 'blog_featured_style_2_title_size' );

if ( $title_position === 'title-over' ) {
	$title_alignment = typer()->get_option( 'blog_featured_style_2_title_over_alignment' );

	if ( $title_alignment === 'center' ) {
		$article_classes[] = 'entry-header--h-center';
	} elseif ( $title_alignment === 'middle' ) {
		$article_classes[] = 'entry-header--v-center';
	} elseif ( $title_alignment === 'middle-center' ) {
		$article_classes[] = 'entry-header--h-center';
		$article_classes[] = 'entry-header--v-center';
	}
} elseif ( $title_position === 'half' ) {
	$article_classes[] = 'entry-header--v-center';
}

$article_classes = implode( ' ', $article_classes );


typer()->set_post_data( 'media_image_width', 'full-width' );
typer()->set_post_data( 'media_gallery_width', 'full-width' );
typer()->set_post_data( 'media_video_width', 'full-width' );

$excerpt = typer()->get_excerpt();

$show_category_nav = typer()->get_post_data( 'show_category_nav', in_array( typer()->get_option( 'blog_featured_style_2_media_catbread_type' ), [
	'category',
	'category-breadcrumb'
] ) );

$show_breadcrumbs = typer()->get_post_data( 'show_breadcrumbs', in_array( typer()->get_option( 'blog_featured_style_2_media_catbread_type' ), [
	'breadcrumb',
	'category-breadcrumb'
] ) );

$show_excerpt = typer()->get_post_data( 'show_excerpt', typer()->get_option( 'blog_featured_style_2_excerpt_show' ) );

$show_entry_meta = typer()->get_post_data( 'show_entry_meta', typer()->get_option( 'blog_featured_style_2_meta_show' ) );

$show_button = typer()->get_post_data( 'show_button', true );

?>

<div class="svq-panel has-featured-image <?php echo esc_attr( $panel_classes ) ?>">
	<?php
	if ( ! get_post_format() && typer()->get_blog_option( 'media_image_enabled' ) ) {
		typer()->get_template_part( 'template-parts/content/panel/image' );
	} elseif ( in_array( get_post_format(), [ 'quote', 'audio', 'image' ] ) ) {
		typer()->get_template_part( 'template-parts/content/panel/image' );
	} else if ( get_post_format() === 'video' ) {
		typer()->get_template_part( 'template-parts/content/panel/video' );
	} else if ( get_post_format() === 'gallery' ) {
		typer()->get_template_part( 'template-parts/content/panel/gallery' );
	}

	?>

	<article class="entry-header <?php echo esc_attr( $article_classes ) ?>">
		<div class="entry-header-content">
			<?php

			if ( $show_category_nav ) {
				typer()->get_categories_nav();
			}

			if ( $show_breadcrumbs ) {
				typer()->get_breadcrumbs();
			}

			$quote = '';
			if ( get_post_format() === 'quote' ) {
				$quote = \Typer_Assets::instance()->get_content_quote( apply_filters( 'the_content', $post->post_content ) );
				add_filter( 'the_content', [ \Typer_Assets::instance(), 'remove_first_content_quote' ] );
			}

			?>

			<?php if ( ! $quote ) : ?>
				<h1 class="entry-title">
					<?php if ( $has_media ): ?>
						<span class="will-animate d-block" data-cssanimate="fadeIn">
							<?php the_title() ?>
						</span>
					<?php else : ?>
						<?php the_title() ?>
					<?php endif; ?>
				</h1>
			<?php else: ?>
				<?php typer()->get_template_part( 'template-parts/content/panel/quote', null, compact( 'quote' ) ) ?>
			<?php endif; ?>

			<?php if ( $excerpt && $show_excerpt ) : ?>
				<div class="post-excerpt">
					<a href="<?php the_permalink() ?>" class="screen-reader-link">
						<?php echo $excerpt ?>
					</a>
				</div>
			<?php endif; ?>

			<?php if ( get_post_format() === 'audio' ) : ?>
				<?php typer()->get_template_part( 'template-parts/content/panel/audio' ) ?>
			<?php endif; ?>

			<?php if ( $show_entry_meta ) : ?>
				<?php typer()->get_template_part( 'template-parts/content/entry-meta' ) ?>
			<?php endif; ?>

			<?php if ( $show_button ): ?>
				<div class="entry-meta will-animate" data-cssanimate="fadeInUp">
					<a type="button" href="<?php the_permalink() ?>"
					   class="btn btn-dark btn-rounded btn-icon--right btn-customize">
						<span class="svq-icon icon-long-arrow-right"></span>
						<?php esc_html_e( 'Read article', 'typer' ) ?>
					</a>
				</div>
			<?php endif; ?>
		</div>
	</article>
</div>
