<?php

use function Seventhqueen\Typer\typer;

$allowed_post_formats = [ 'image', 'video', 'gallery' ];

if ( typer()->get_option( 'blog_post_image_standard' ) ) {
	$allowed_post_formats[] = 'standard';
}

$post_format = get_post_format() ?: 'standard';
$item_format = $post_format === 'standard' ? 'image' : $post_format;

if ( in_array( $post_format, $allowed_post_formats, true ) ) {
	$overlay_classes = '';
	$overlay         = typer()->get_blog_option( 'media_' . $item_format . '_overlay' );
	$overlay_show    = typer()->get_blog_option( 'media_' . $item_format . '_overlay_show' );

	if ( $overlay !== 'none' && in_array( $overlay_show, [ 'listing', 'both' ] ) ) {
		$overlay_classes .= 'svq-overlay svq-overlay--' . $overlay;
	}

	typer()->get_template_part(
		'template-parts/archive/article-format/' . $item_format,
		null,
		compact( 'show_thumbnail_block', 'overlay_classes' )
	);
}
