<?php

namespace Seventhqueen\Typer;

global $post;

$col_classes          = [];
$show_thumbnail_block = false;

$post_format = get_post_format() ?: 'standard';

$article_classes = [ 'svq-article' ];
$has_media       = typer()->has_media();

$allowed_post_formats = [ 'image', 'video', 'gallery' ];

if ( typer()->get_option( 'blog_post_image_standard' ) ) {
	$allowed_post_formats[] = 'standard';
}

if ( $has_media && in_array( $post_format, $allowed_post_formats, true ) ) {
	$article_classes[]    = 'has-post-thumbnail';
	$show_thumbnail_block = true;

	$video_type = get_post_meta( get_the_ID(), '_sq_post_video_type', true );

	if ( $video_type === 'hosted' && get_post_meta( get_the_ID(), '_sq_post_video_illustration', true ) ) {
		$article_classes[] = 'has-illustration-video';
	}

	if ( typer()->get_post_data( 'media_position' ) ) {
		$article_classes[] = 'ty-thumb-' . typer()->get_post_data( 'media_position' );
	}
}

if ( $has_media && in_array( $post_format, $allowed_post_formats, true ) && typer()->get_post_data( 'media_width', 'normal' ) === 'wide' ) {
	$article_classes[] = 'post-thumbnail-wide';
}


$article_classes[] = ! get_the_title() ? 'svq-no-title' : '';

$show_categories   = (bool) typer()->get_post_data( 'show_category', typer()->get_option( 'blog_post_show_categories' ) );
$article_classes[] = ! $show_categories ? 'svq-no-categories' : '';

$show_excerpt      = (bool) typer()->get_post_data( 'show_excerpt', $post_format !== 'audio' && typer()->get_excerpt() );
$article_classes[] = ! $show_excerpt ? 'svq-no-excerpt' : '';

$show_meta         = (bool) typer()->get_post_data( 'show_meta', ! empty( typer()->get_option( 'blog_post_meta_items' ) ) );
$article_classes[] = ! $show_meta ? 'svq-no-meta' : '';

$has_grid_span = (bool) typer()->get_post_data( 'grid_span' );

$col_classes[] = typer()->get_post_data( 'col_classes', '' );
$col_classes[] = typer()->get_post_data( 'grid_span', '' );

$quote = '';
if ( $post_format === 'quote' ) {
	$quote = \Typer_Assets::instance()->get_content_quote( apply_filters( 'the_content', $post->post_content ) );
}

?>

<div class="svq-article-col <?php echo esc_attr( implode( ' ', $col_classes ) ) ?>">
	<article <?php typer_post_class( $article_classes ); ?>>

		<?php

		if ( ! isset( $components ) ) {
			$components = typer()->get_article_components();
		}

		if ( ! $show_categories ) {
			$key = array_search( 'categories', $components, true );
			unset( $components[ $key ] );
		}

		if ( ! $show_excerpt ) {
			$key = array_search( 'excerpt', $components, true );
			unset( $components[ $key ] );
		}

		if ( ! $show_meta ) {
			$key = array_search( 'meta', $components, true );
			unset( $components[ $key ] );
		}

		if ( $has_grid_span && ( $key = array_search( 'media', $components, true ) ) !== false ) {
			typer()->get_template_part( 'template-parts/archive/article-parts/media', null, compact( 'show_thumbnail_block' ) );
			unset( $components[ $key ] );
		}

		?>

		<?php if ( $has_grid_span ) : ?>
		<div class="svq-article-content">
			<?php endif; ?>

			<?php

			foreach ( $components as $component ) {
				$vars = [];

				if ( $component === 'media' ) {
					$vars = compact( 'show_thumbnail_block' );
				}

				if ( $component === 'meta' ) {
					$vars = compact( 'post' );
				}

				if ( $component === 'title' || $component === 'excerpt' ) {
					$vars = compact( 'quote' );
				}

				typer()->get_template_part( 'template-parts/archive/article-parts/' . $component, null, $vars );
			}

			?>

			<?php if ( $has_grid_span ) : ?>
		</div>
	<?php endif; ?>

	</article>
</div>
