<?php

use function Seventhqueen\Typer\typer;

global $post;

if ( ! isset( $image_position ) ) {
	$image_position = 'right';
}

if ( ! isset( $show_category ) ) {
	$show_category = true;
}

if ( ! isset( $show_excerpt ) ) {
	$show_excerpt = true;
}

if ( ! isset( $show_meta_author ) ) {
	$show_meta_author = true;
}

if ( ! isset( $show_meta_date ) ) {
	$show_meta_date = true;
}

$col_classes          = [];
$show_thumbnail_block = false;

$allowed_post_formats = [ 'image', 'video', 'gallery' ];
if ( typer()->get_option( 'blog_post_image_standard' ) ) {
	$allowed_post_formats[] = 'standard';
}

$post_format = get_post_format() ?: 'standard';

$article_classes[] = 'svq-article';
$has_media         = typer()->has_media();

if ( $has_media && in_array( $post_format, $allowed_post_formats, true ) ) {
	$article_classes[]    = 'has-post-thumbnail';
	$show_thumbnail_block = true;

	$video_type = get_post_meta( get_the_ID(), '_sq_post_video_type', true );

	if ( $video_type === 'hosted' && get_post_meta( get_the_ID(), '_sq_post_video_illustration', true ) ) {
		$article_classes[] = 'has-illustration-video';
	}
}

if ( ! isset( $media_width ) ) {
	$media_width = 'normal';
}

if ( $media_width === 'wide' && $has_media && in_array( $post_format, $allowed_post_formats, true ) ) {
	$article_classes[] = 'post-thumbnail-wide';
}

if ( ! get_the_title() ) {
	$article_classes[] = 'svq-no-title';
}

if ( $post_format !== 'audio' && ! typer()->get_excerpt() && ! $has_media ) {
	$article_classes[] = 'svq-no-excerpt';
} else if ( $post_format !== 'audio' && ! typer()->get_excerpt() ) {
	$article_classes[] = 'svq-no-excerpt';
}

$article_classes[] = 'ty-thumb-' . ( $image_position ? 'right' : 'left' );

$col_classes = implode( ' ', $col_classes );

$quote = '';
if ( $post_format === 'quote' ) {
	$quote = \Typer_Assets::instance()->get_content_quote( apply_filters( 'the_content', $post->post_content ) );
}

typer()->set_post_data( 'listing_type', 'list-widget' );
typer()->set_post_data( 'media_width', 'normal' );
typer()->set_post_data( 'media_size', 'typer-img-sm' );
typer()->set_post_data( 'media_aspect_ratio', '1-1' );
?>

<div class="svq-article-col <?php echo esc_attr( $col_classes ) ?>">
	<article <?php typer_post_class( $article_classes ); ?>>

		<?php
		$listing_format = $post_format === 'standard' ? 'image' : $post_format;

		if ( in_array( $post_format, $allowed_post_formats, true ) ) {
			$overlay_classes = '';
			$overlay         = typer()->get_blog_option( 'media_' . $listing_format . '_overlay' );
			$overlay_show    = typer()->get_blog_option( 'media_' . $listing_format . '_overlay_show' );

			if ( $overlay !== 'none' && in_array( $overlay_show, [ 'listing', 'both' ] ) ) {
				$overlay_classes .= 'svq-overlay svq-overlay--' . $overlay;
			}

			typer()->get_template_part(
				'template-parts/archive/article-format/' . $listing_format,
				null,
				compact( 'show_thumbnail_block', 'overlay_classes' )
			);
		}
		?>

		<?php if ( $show_category ) : ?>
			<?php typer()->get_categories_nav( false ) ?>
		<?php endif; ?>

		<?php if ( ! $quote ) : ?>
			<div class="heading-title">
				<div class="heading-title-content">
					<h4 class="heading-title-text">
						<a href="<?php the_permalink() ?>" class="heading-title-link">
							<?php the_title() ?>
						</a>
					</h4>
				</div>
			</div>
		<?php endif; ?>

		<?php if ( $show_excerpt ) : ?>
			<div class="post-excerpt">
				<?php if ( $quote ) : ?>
					<a href="<?php the_permalink() ?>" class="post-quote-link"></a>
					<?php typer()->get_template_part( 'template-parts/archive/article-format/quote', null, compact( 'quote' ) ); ?>
				<?php endif; ?>

				<?php if ( $post_format === 'audio' ) : ?>
					<?php typer()->get_template_part( 'template-parts/content/panel/audio' ) ?>
				<?php endif; ?>

				<?php if ( ! $quote ) : ?>
					<a href="<?php the_permalink() ?>" class="screen-reader-link">
						<?php echo typer()->get_excerpt() ?>
					</a>
				<?php endif; ?>
			</div>
		<?php endif; ?>

		<div class="entry-meta">
			<div class="entry-meta__content">
				<?php if ( $show_meta_author ) : ?>
					<span class="by-line">
			            <span class="author">
				             <?php printf( esc_html__( 'Written by %s', 'typer' ), get_the_author_posts_link() ) ?>
			            </span>
			        </span>
				<?php endif; ?>
				<?php if ( $show_meta_date ) : ?>
					<span class="posted-on">
						<?php echo typer()->get_the_date() ?>
					</span>
				<?php endif; ?>
			</div>

			<?php
			/**
			 * After Entry meta hook
			 */

			if ( $show_meta_author || $show_meta_date ) {
				do_action( 'typer_post_list_after_meta' );
			}
			?>

		</div>

	</article>
</div>
